"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("../../../src/components/VResponsive/VResponsive.sass");

var _measurable = _interopRequireDefault(require("../../mixins/measurable"));

var _mixins = _interopRequireDefault(require("../../util/mixins"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Mixins
// Utils

/* @vue/component */
var _default = (0, _mixins.default)(_measurable.default).extend({
  name: 'v-responsive',
  props: {
    aspectRatio: [String, Number]
  },
  computed: {
    computedAspectRatio: function computedAspectRatio() {
      return Number(this.aspectRatio);
    },
    aspectStyle: function aspectStyle() {
      return this.computedAspectRatio ? {
        paddingBottom: 1 / this.computedAspectRatio * 100 + '%'
      } : undefined;
    },
    __cachedSizer: function __cachedSizer() {
      if (!this.aspectStyle) return [];
      return this.$createElement('div', {
        style: this.aspectStyle,
        staticClass: 'v-responsive__sizer'
      });
    }
  },
  methods: {
    genContent: function genContent() {
      return this.$createElement('div', {
        staticClass: 'v-responsive__content'
      }, this.$slots.default);
    }
  },
  render: function render(h) {
    return h('div', {
      staticClass: 'v-responsive',
      style: this.measurableStyles,
      on: this.$listeners
    }, [this.__cachedSizer, this.genContent()]);
  }
});

exports.default = _default;
//# sourceMappingURL=VResponsive.js.map