"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _bootable = _interopRequireDefault(require("../bootable"));

var _helpers = require("../../util/helpers");

var _mixins = _interopRequireDefault(require("../../util/mixins"));

var _console = require("../../util/console");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function validateAttachTarget(val) {
  var type = _typeof(val);

  if (type === 'boolean' || type === 'string') return true;
  return val.nodeType === Node.ELEMENT_NODE;
}
/* @vue/component */


var _default = (0, _mixins.default)(_bootable.default).extend({
  name: 'detachable',
  props: {
    attach: {
      default: false,
      validator: validateAttachTarget
    },
    contentClass: {
      type: String,
      default: ''
    }
  },
  data: function data() {
    return {
      activatorNode: null,
      hasDetached: false
    };
  },
  watch: {
    attach: function attach() {
      this.hasDetached = false;
      this.initDetach();
    },
    hasContent: function hasContent() {
      this.$nextTick(this.initDetach);
    }
  },
  beforeMount: function beforeMount() {
    var _this = this;

    this.$nextTick(function () {
      if (_this.activatorNode) {
        var activator = Array.isArray(_this.activatorNode) ? _this.activatorNode : [_this.activatorNode];
        activator.forEach(function (node) {
          if (!node.elm) return;
          if (!_this.$el.parentNode) return;
          var target = _this.$el === _this.$el.parentNode.firstChild ? _this.$el : _this.$el.nextSibling;

          _this.$el.parentNode.insertBefore(node.elm, target);
        });
      }
    });
  },
  mounted: function mounted() {
    this.hasContent && this.initDetach();
  },
  deactivated: function deactivated() {
    this.isActive = false;
  },
  beforeDestroy: function beforeDestroy() {
    // IE11 Fix
    try {
      if (this.$refs.content && this.$refs.content.parentNode) {
        this.$refs.content.parentNode.removeChild(this.$refs.content);
      }

      if (this.activatorNode) {
        var activator = Array.isArray(this.activatorNode) ? this.activatorNode : [this.activatorNode];
        activator.forEach(function (node) {
          node.elm && node.elm.parentNode && node.elm.parentNode.removeChild(node.elm);
        });
      }
    } catch (e) {
      console.log(e);
    }
  },
  methods: {
    getScopeIdAttrs: function getScopeIdAttrs() {
      var scopeId = (0, _helpers.getObjectValueByPath)(this.$vnode, 'context.$options._scopeId');
      return scopeId && _defineProperty({}, scopeId, '');
    },
    initDetach: function initDetach() {
      if (this._isDestroyed || !this.$refs.content || this.hasDetached || // Leave menu in place if attached
      // and dev has not changed target
      this.attach === '' || // If used as a boolean prop (<v-menu attach>)
      this.attach === true || // If bound to a boolean (<v-menu :attach="true">)
      this.attach === 'attach' // If bound as boolean prop in pug (v-menu(attach))
      ) return;
      var target;

      if (this.attach === false) {
        // Default, detach to app
        target = document.querySelector('[data-app]');
      } else if (typeof this.attach === 'string') {
        // CSS selector
        target = document.querySelector(this.attach);
      } else {
        // DOM Element
        target = this.attach;
      }

      if (!target) {
        (0, _console.consoleWarn)("Unable to locate target ".concat(this.attach || '[data-app]'), this);
        return;
      }

      target.appendChild(this.$refs.content);
      this.hasDetached = true;
    }
  }
});

exports.default = _default;
//# sourceMappingURL=index.js.map