"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = _interopRequireDefault(require("vue"));

var _ripple = _interopRequireDefault(require("../../directives/ripple"));

var _helpers = require("../../util/helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var _default = _vue.default.extend({
  name: 'routable',
  directives: {
    Ripple: _ripple.default
  },
  props: {
    activeClass: String,
    append: Boolean,
    disabled: Boolean,
    exact: {
      type: Boolean,
      default: undefined
    },
    exactActiveClass: String,
    link: Boolean,
    href: [String, Object],
    to: [String, Object],
    nuxt: Boolean,
    replace: Boolean,
    ripple: {
      type: [Boolean, Object],
      default: null
    },
    tag: String,
    target: String
  },
  data: function data() {
    return {
      isActive: false,
      proxyClass: ''
    };
  },
  computed: {
    classes: function classes() {
      var classes = {};
      if (this.to) return classes;
      if (this.activeClass) classes[this.activeClass] = this.isActive;
      if (this.proxyClass) classes[this.proxyClass] = this.isActive;
      return classes;
    },
    computedRipple: function computedRipple() {
      var _this$ripple;

      return (_this$ripple = this.ripple) != null ? _this$ripple : !this.disabled && this.isClickable;
    },
    isClickable: function isClickable() {
      if (this.disabled) return false;
      return Boolean(this.isLink || this.$listeners.click || this.$listeners['!click'] || this.$attrs.tabindex);
    },
    isLink: function isLink() {
      return this.to || this.href || this.link;
    },
    styles: function styles() {
      return {};
    }
  },
  watch: {
    $route: 'onRouteChange'
  },
  methods: {
    click: function click(e) {
      this.$emit('click', e);
    },
    generateRouteLink: function generateRouteLink() {
      var _data;

      var exact = this.exact;
      var tag;
      var data = (_data = {
        attrs: {
          tabindex: 'tabindex' in this.$attrs ? this.$attrs.tabindex : undefined
        },
        class: this.classes,
        style: this.styles,
        props: {},
        directives: [{
          name: 'ripple',
          value: this.computedRipple
        }]
      }, _defineProperty(_data, this.to ? 'nativeOn' : 'on', _objectSpread({}, this.$listeners, {
        click: this.click
      })), _defineProperty(_data, "ref", 'link'), _data);

      if (typeof this.exact === 'undefined') {
        exact = this.to === '/' || this.to === Object(this.to) && this.to.path === '/';
      }

      if (this.to) {
        // Add a special activeClass hook
        // for component level styles
        var activeClass = this.activeClass;
        var exactActiveClass = this.exactActiveClass || activeClass;

        if (this.proxyClass) {
          activeClass = "".concat(activeClass, " ").concat(this.proxyClass).trim();
          exactActiveClass = "".concat(exactActiveClass, " ").concat(this.proxyClass).trim();
        }

        tag = this.nuxt ? 'nuxt-link' : 'router-link';
        Object.assign(data.props, {
          to: this.to,
          exact: exact,
          activeClass: activeClass,
          exactActiveClass: exactActiveClass,
          append: this.append,
          replace: this.replace
        });
      } else {
        tag = this.href && 'a' || this.tag || 'div';
        if (tag === 'a' && this.href) data.attrs.href = this.href;
      }

      if (this.target) data.attrs.target = this.target;
      return {
        tag: tag,
        data: data
      };
    },
    onRouteChange: function onRouteChange() {
      var _this = this;

      if (!this.to || !this.$refs.link || !this.$route) return;
      var activeClass = "".concat(this.activeClass, " ").concat(this.proxyClass || '').trim();
      var path = "_vnode.data.class.".concat(activeClass);
      this.$nextTick(function () {
        /* istanbul ignore else */
        if ((0, _helpers.getObjectValueByPath)(_this.$refs.link, path)) {
          _this.toggle();
        }
      });
    },
    toggle: function toggle() {}
  }
});

exports.default = _default;
//# sourceMappingURL=index.js.map