"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = _interopRequireDefault(require("vue"));

var _helpers = require("../../util/helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

/* @vue/component */
var _default = _vue.default.extend().extend({
  name: 'stackable',
  data: function data() {
    return {
      stackElement: null,
      stackExclude: null,
      stackMinZIndex: 0,
      isActive: false
    };
  },
  computed: {
    activeZIndex: function activeZIndex() {
      if (typeof window === 'undefined') return 0;
      var content = this.stackElement || this.$refs.content; // Return current zindex if not active

      var index = !this.isActive ? (0, _helpers.getZIndex)(content) : this.getMaxZIndex(this.stackExclude || [content]) + 2;
      if (index == null) return index; // Return max current z-index (excluding self) + 2
      // (2 to leave room for an overlay below, if needed)

      return parseInt(index);
    }
  },
  methods: {
    getMaxZIndex: function getMaxZIndex() {
      var exclude = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var base = this.$el; // Start with lowest allowed z-index or z-index of
      // base component's element, whichever is greater

      var zis = [this.stackMinZIndex, (0, _helpers.getZIndex)(base)]; // Convert the NodeList to an array to
      // prevent an Edge bug with Symbol.iterator
      // https://github.com/vuetifyjs/vuetify/issues/2146

      var activeElements = [].concat(_toConsumableArray(document.getElementsByClassName('v-menu__content--active')), _toConsumableArray(document.getElementsByClassName('v-dialog__content--active'))); // Get z-index for all active dialogs

      for (var index = 0; index < activeElements.length; index++) {
        if (!exclude.includes(activeElements[index])) {
          zis.push((0, _helpers.getZIndex)(activeElements[index]));
        }
      }

      return Math.max.apply(Math, zis);
    }
  }
});

exports.default = _default;
//# sourceMappingURL=index.js.map