"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Breakpoint = void 0;

var _service = require("../service");

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Breakpoint =
/*#__PURE__*/
function (_Service) {
  _inherits(Breakpoint, _Service);

  function Breakpoint(preset) {
    var _this;

    _classCallCheck(this, Breakpoint);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Breakpoint).call(this)); // Public

    _this.xs = false;
    _this.sm = false;
    _this.md = false;
    _this.lg = false;
    _this.xl = false;
    _this.xsOnly = false;
    _this.smOnly = false;
    _this.smAndDown = false;
    _this.smAndUp = false;
    _this.mdOnly = false;
    _this.mdAndDown = false;
    _this.mdAndUp = false;
    _this.lgOnly = false;
    _this.lgAndDown = false;
    _this.lgAndUp = false;
    _this.xlOnly = false; // Value is xs to match v2.x functionality

    _this.name = 'xs';
    _this.height = 0;
    _this.width = 0; // TODO: Add functionality to detect this dynamically in v3
    // Value is true to match v2.x functionality

    _this.mobile = true;
    _this.resizeTimeout = 0;
    var _preset$Breakpoint$pr = preset[Breakpoint.property],
        mobileBreakpoint = _preset$Breakpoint$pr.mobileBreakpoint,
        scrollBarWidth = _preset$Breakpoint$pr.scrollBarWidth,
        thresholds = _preset$Breakpoint$pr.thresholds;
    _this.mobileBreakpoint = mobileBreakpoint;
    _this.scrollBarWidth = scrollBarWidth;
    _this.thresholds = thresholds;
    return _this;
  }

  _createClass(Breakpoint, [{
    key: "init",
    value: function init() {
      this.update();
      /* istanbul ignore if */

      if (typeof window === 'undefined') return;
      window.addEventListener('resize', this.onResize.bind(this), {
        passive: true
      });
    }
    /* eslint-disable-next-line max-statements */

  }, {
    key: "update",
    value: function update() {
      var ssr = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      var height = ssr ? 0 : this.getClientHeight();
      var width = ssr ? 0 : this.getClientWidth();
      var xs = width < this.thresholds.xs;
      var sm = width < this.thresholds.sm && !xs;
      var md = width < this.thresholds.md - this.scrollBarWidth && !(sm || xs);
      var lg = width < this.thresholds.lg - this.scrollBarWidth && !(md || sm || xs);
      var xl = width >= this.thresholds.lg - this.scrollBarWidth;
      this.height = height;
      this.width = width;
      this.xs = xs;
      this.sm = sm;
      this.md = md;
      this.lg = lg;
      this.xl = xl;
      this.xsOnly = xs;
      this.smOnly = sm;
      this.smAndDown = (xs || sm) && !(md || lg || xl);
      this.smAndUp = !xs && (sm || md || lg || xl);
      this.mdOnly = md;
      this.mdAndDown = (xs || sm || md) && !(lg || xl);
      this.mdAndUp = !(xs || sm) && (md || lg || xl);
      this.lgOnly = lg;
      this.lgAndDown = (xs || sm || md || lg) && !xl;
      this.lgAndUp = !(xs || sm || md) && (lg || xl);
      this.xlOnly = xl;

      switch (true) {
        case xs:
          this.name = 'xs';
          break;

        case sm:
          this.name = 'sm';
          break;

        case md:
          this.name = 'md';
          break;

        case lg:
          this.name = 'lg';
          break;

        default:
          this.name = 'xl';
          break;
      }

      if (typeof this.mobileBreakpoint === 'number') {
        this.mobile = width < parseInt(this.mobileBreakpoint, 10);
        return;
      }

      var breakpoints = {
        xs: 0,
        sm: 1,
        md: 2,
        lg: 3,
        xl: 4
      };
      var current = breakpoints[this.name];
      var max = breakpoints[this.mobileBreakpoint];
      this.mobile = current <= max;
    }
  }, {
    key: "onResize",
    value: function onResize() {
      clearTimeout(this.resizeTimeout); // Added debounce to match what
      // v-resize used to do but was
      // removed due to a memory leak
      // https://github.com/vuetifyjs/vuetify/pull/2997

      this.resizeTimeout = window.setTimeout(this.update.bind(this), 200);
    } // Cross-browser support as described in:
    // https://stackoverflow.com/questions/1248081

  }, {
    key: "getClientWidth",
    value: function getClientWidth() {
      /* istanbul ignore if */
      if (typeof document === 'undefined') return 0; // SSR

      return Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
    }
  }, {
    key: "getClientHeight",
    value: function getClientHeight() {
      /* istanbul ignore if */
      if (typeof document === 'undefined') return 0; // SSR

      return Math.max(document.documentElement.clientHeight, window.innerHeight || 0);
    }
  }]);

  return Breakpoint;
}(_service.Service);

exports.Breakpoint = Breakpoint;
Breakpoint.property = 'breakpoint';
//# sourceMappingURL=index.js.map