// Mixins
import Themeable from '../../mixins/themeable';
/* @vue/component */

export default Themeable.extend({
  name: 'v-theme-provider',
  props: {
    root: Boolean
  },
  computed: {
    isDark() {
      return this.root ? this.rootIsDark : Themeable.options.computed.isDark.call(this);
    }

  },

  render() {
    /* istanbul ignore next */
    return this.$slots.default && this.$slots.default.find(node => !node.isComment && node.text !== ' ');
  }

});
//# sourceMappingURL=VThemeProvider.js.map