import mergeData from '../../util/mergeData';

function mergeTransitions(dest = [], ...transitions) {
  /* eslint-disable-next-line no-array-constructor */
  return Array().concat(dest, ...transitions);
}

export function createSimpleTransition(name, origin = 'top center 0', mode) {
  return {
    name,
    functional: true,
    props: {
      group: {
        type: Boolean,
        default: false
      },
      hideOnLeave: {
        type: Boolean,
        default: false
      },
      leaveAbsolute: {
        type: Boolean,
        default: false
      },
      mode: {
        type: String,
        default: mode
      },
      origin: {
        type: String,
        default: origin
      }
    },

    render(h, context) {
      const tag = `transition${context.props.group ? '-group' : ''}`;
      const data = {
        props: {
          name,
          mode: context.props.mode
        },
        on: {
          beforeEnter(el) {
            el.style.transformOrigin = context.props.origin;
            el.style.webkitTransformOrigin = context.props.origin;
          }

        }
      };

      if (context.props.leaveAbsolute) {
        data.on.leave = mergeTransitions(data.on.leave, el => el.style.position = 'absolute');
      }

      if (context.props.hideOnLeave) {
        data.on.leave = mergeTransitions(data.on.leave, el => el.style.display = 'none');
      }

      return h(tag, mergeData(context.data, data), context.children);
    }

  };
}
export function createJavascriptTransition(name, functions, mode = 'in-out') {
  return {
    name,
    functional: true,
    props: {
      mode: {
        type: String,
        default: mode
      }
    },

    render(h, context) {
      return h('transition', mergeData(context.data, {
        props: {
          name
        },
        on: functions
      }), context.children);
    }

  };
}
//# sourceMappingURL=createTransition.js.map