import { createVNode as _createVNode } from "vue";
// Styles
import "./VApp.css"; // Composables

import { makeThemeProps, useTheme } from "../../composables/theme.mjs";
import { createLayout, makeLayoutProps } from "../../composables/layout.mjs"; // Utilities

import { defineComponent } from "../../util/index.mjs";
import { useRtl } from "../../composables/rtl.mjs";
export default defineComponent({
  name: 'VApp',
  props: { ...makeLayoutProps({
      fullHeight: true
    }),
    ...makeThemeProps()
  },

  setup(props, {
    slots
  }) {
    const {
      themeClasses
    } = useTheme(props);
    const {
      layoutClasses
    } = createLayout(props);
    const {
      rtlClasses
    } = useRtl();
    return () => {
      var _slots$default;

      return _createVNode("div", {
        "class": ['v-application', themeClasses.value, layoutClasses.value, rtlClasses.value],
        "data-app": "true"
      }, [_createVNode("div", {
        "class": "v-application__wrap"
      }, [(_slots$default = slots.default) == null ? void 0 : _slots$default.call(slots)])], 2);
    };
  }

});
//# sourceMappingURL=VApp.mjs.map