// @ts-nocheck

/* eslint-disable */
import "./VSimpleCheckbox.css";
import ripple from "../../directives/ripple/index.mjs";
import Vue from 'vue';
import { VIcon } from "../VIcon/index.mjs"; // Mixins

import Colorable from "../../mixins/colorable/index.mjs";
import Themeable from "../../mixins/themeable/index.mjs"; // Utilities

import mergeData from "../../util/mergeData.mjs";
import { wrapInArray } from "../../util/helpers.mjs";
export default Vue.extend({
  name: 'v-simple-checkbox',
  functional: true,
  directives: {
    ripple
  },
  props: { ...Colorable.options.props,
    ...Themeable.options.props,
    disabled: Boolean,
    ripple: {
      type: Boolean,
      default: true
    },
    value: Boolean,
    indeterminate: Boolean,
    indeterminateIcon: {
      type: String,
      default: '$checkboxIndeterminate'
    },
    onIcon: {
      type: String,
      default: '$checkboxOn'
    },
    offIcon: {
      type: String,
      default: '$checkboxOff'
    }
  },

  render(h, {
    props,
    data,
    listeners
  }) {
    const children = [];
    let icon = props.offIcon;
    if (props.indeterminate) icon = props.indeterminateIcon;else if (props.value) icon = props.onIcon;
    children.push(h(VIcon, Colorable.options.methods.setTextColor(props.value && props.color, {
      props: {
        disabled: props.disabled,
        dark: props.dark,
        light: props.light
      }
    }), icon));

    if (props.ripple && !props.disabled) {
      const ripple = h('div', Colorable.options.methods.setTextColor(props.color, {
        staticClass: 'v-input--selection-controls__ripple',
        directives: [{
          name: 'ripple',
          value: {
            center: true
          }
        }]
      }));
      children.push(ripple);
    }

    return h('div', mergeData(data, {
      class: {
        'v-simple-checkbox': true,
        'v-simple-checkbox--disabled': props.disabled
      },
      on: {
        click: e => {
          e.stopPropagation();

          if (data.on && data.on.input && !props.disabled) {
            wrapInArray(data.on.input).forEach(f => f(!props.value));
          }
        }
      }
    }), [h('div', {
      staticClass: 'v-input--selection-controls__input'
    }, children)]);
  }

});
//# sourceMappingURL=VSimpleCheckbox.mjs.map