// @ts-nocheck

/* eslint-disable */
// Styles
import "./VColorPickerPreview.css"; // Components

import VSlider from "../VSlider/VSlider.mjs"; // Utilities

import { RGBtoCSS, RGBAtoCSS } from "../../util/colorUtils.mjs"; // Types

import Vue from 'vue';
import { fromHSVA } from "./util/index.mjs";
export default Vue.extend({
  name: 'v-color-picker-preview',
  props: {
    color: Object,
    disabled: Boolean,
    hideAlpha: Boolean
  },
  methods: {
    genAlpha() {
      return this.genTrack({
        staticClass: 'v-color-picker__alpha',
        props: {
          thumbColor: 'grey lighten-2',
          hideDetails: true,
          value: this.color.alpha,
          step: 0,
          min: 0,
          max: 1
        },
        style: {
          backgroundImage: this.disabled ? undefined : `linear-gradient(to ${this.$vuetify.rtl ? 'left' : 'right'}, transparent, ${RGBtoCSS(this.color.rgba)})`
        },
        on: {
          input: val => this.color.alpha !== val && this.$emit('update:color', fromHSVA({ ...this.color.hsva,
            a: val
          }))
        }
      });
    },

    genSliders() {
      return this.$createElement('div', {
        staticClass: 'v-color-picker__sliders'
      }, [this.genHue(), !this.hideAlpha && this.genAlpha()]);
    },

    genDot() {
      return this.$createElement('div', {
        staticClass: 'v-color-picker__dot'
      }, [this.$createElement('div', {
        style: {
          background: RGBAtoCSS(this.color.rgba)
        }
      })]);
    },

    genHue() {
      return this.genTrack({
        staticClass: 'v-color-picker__hue',
        props: {
          thumbColor: 'grey lighten-2',
          hideDetails: true,
          value: this.color.hue,
          step: 0,
          min: 0,
          max: 360
        },
        on: {
          input: val => this.color.hue !== val && this.$emit('update:color', fromHSVA({ ...this.color.hsva,
            h: val
          }))
        }
      });
    },

    genTrack(options) {
      return this.$createElement(VSlider, {
        class: 'v-color-picker__track',
        ...options,
        props: {
          disabled: this.disabled,
          ...options.props
        }
      });
    }

  },

  render(h) {
    return h('div', {
      staticClass: 'v-color-picker__preview',
      class: {
        'v-color-picker__preview--hide-alpha': this.hideAlpha
      }
    }, [this.genDot(), this.genSliders()]);
  }

});
//# sourceMappingURL=VColorPickerPreview.mjs.map