import { mergeProps as _mergeProps, resolveDirective as _resolveDirective, withDirectives as _withDirectives, createVNode as _createVNode, vShow as _vShow, Fragment as _Fragment } from "vue";
// Styles
import "./VField.css"; // Components

import { VBtn } from "../VBtn/index.mjs";
import { VExpandXTransition } from "../transitions/index.mjs";
import { VIcon } from "../VIcon/index.mjs";
import { VInput } from "../VInput/index.mjs";
import VFieldLabel from "./VFieldLabel.mjs"; // Composables

import { makeThemeProps, useTheme } from "../../composables/theme.mjs";
import { makeTransitionProps, MaybeTransition } from "../../composables/transition.mjs";
import { useBackgroundColor, useTextColor } from "../../composables/color.mjs";
import { useProxiedModel } from "../../composables/proxiedModel.mjs"; // Utilities

import { computed, ref, toRef, watch, watchEffect } from 'vue';
import { convertToUnit, defineComponent, getUid, nullifyTransforms, propsFactory, standardEasing, useRender } from "../../util/index.mjs"; // Types

const allowedVariants = ['underlined', 'outlined', 'filled', 'contained', 'plain'];
export const makeVFieldProps = propsFactory({
  disabled: Boolean,
  appendInnerIcon: String,
  bgColor: String,
  clearable: Boolean,
  clearIcon: {
    type: String,
    default: '$clear'
  },
  color: String,
  // TODO: implement auto
  hideDetails: [Boolean, String],
  hint: String,
  id: String,
  label: String,
  loading: Boolean,
  persistentHint: Boolean,
  prependInnerIcon: String,
  reverse: Boolean,
  singleLine: Boolean,
  variant: {
    type: String,
    default: 'filled',
    validator: v => allowedVariants.includes(v)
  },
  ...makeThemeProps(),
  ...makeTransitionProps({
    transition: 'slide-y-transition'
  })
}, 'v-field');
export const VField = defineComponent({
  name: 'VField',
  inheritAttrs: false,
  props: {
    active: Boolean,
    dirty: Boolean,
    ...makeVFieldProps()
  },
  emits: {
    'click:clear': e => true,
    'click:prepend-inner': e => true,
    'click:append-inner': e => true,
    'click:control': props => true,
    'update:active': active => true
  },

  setup(props, {
    attrs,
    emit,
    slots
  }) {
    const {
      themeClasses
    } = useTheme(props);
    const isActive = useProxiedModel(props, 'active');
    const uid = getUid();
    const labelRef = ref();
    const floatingLabelRef = ref();
    const controlRef = ref();
    const inputRef = ref();
    const isFocused = ref(false);
    const id = computed(() => props.id || `input-${uid}`);
    watchEffect(() => isActive.value = isFocused.value || props.dirty);
    const {
      backgroundColorClasses,
      backgroundColorStyles
    } = useBackgroundColor(toRef(props, 'bgColor'));
    const {
      textColorClasses,
      textColorStyles
    } = useTextColor(computed(() => {
      return isFocused.value ? props.color : undefined;
    }));
    watch(isActive, val => {
      if (!props.singleLine) {
        const el = labelRef.value.$el;
        const targetEl = floatingLabelRef.value.$el;
        const rect = nullifyTransforms(el);
        const targetRect = targetEl.getBoundingClientRect();
        const x = targetRect.x - rect.x;
        const y = targetRect.y - rect.y - (rect.height / 2 - targetRect.height / 2);
        const targetWidth = targetRect.width / 0.75;
        const width = Math.abs(targetWidth - rect.width) > 1 ? {
          maxWidth: convertToUnit(targetWidth)
        } : undefined;
        const duration = parseFloat(getComputedStyle(el).transitionDuration) * 1000;
        const scale = parseFloat(getComputedStyle(targetEl).getPropertyValue('--v-field-label-scale'));
        el.style.visibility = 'visible';
        targetEl.style.visibility = 'hidden';
        el.animate([{
          transform: 'translate(0)'
        }, {
          transform: `translate(${x}px, ${y}px) scale(${scale})`,
          ...width
        }], {
          duration,
          easing: standardEasing,
          direction: val ? 'normal' : 'reverse'
        }).finished.then(() => {
          el.style.removeProperty('visibility');
          targetEl.style.removeProperty('visibility');
        });
      }
    }, {
      flush: 'post'
    });

    function focus() {
      isFocused.value = true;
    }

    function blur() {
      isFocused.value = false;
    }

    const slotProps = computed(() => ({
      isActive: isActive.value,
      isDirty: props.dirty,
      isFocused: isFocused.value,
      inputRef,
      controlRef,
      focus,
      blur
    }));

    function onClick(e) {
      if (e.target !== document.activeElement) {
        e.preventDefault();
      }

      emit('click:control', slotProps.value);
    }

    useRender(() => {
      var _slots$prependInner, _slots$default, _inputRef$value, _slots$appendInner;

      const isOutlined = props.variant === 'outlined';
      const hasDetails = slots.details || props.hint;
      const hasPrepend = slots.prependInner || props.prependInnerIcon;
      const hasClear = props.clearable || slots.clear;
      const hasAppend = slots.appendInner || props.appendInnerIcon || hasClear;
      const label = slots.label ? slots.label({
        label: props.label,
        props: {
          for: id.value
        }
      }) : props.label;
      return _createVNode(VInput, _mergeProps({
        "class": ['v-field', {
          'v-field--active': isActive.value,
          'v-field--appended': hasAppend,
          'v-field--dirty': props.dirty,
          'v-field--disabled': props.disabled,
          'v-field--focused': isFocused.value,
          'v-field--has-background': !!props.bgColor,
          'v-field--has-details': hasDetails,
          'v-field--hide-details': props.hideDetails,
          'v-field--prepended': hasPrepend,
          'v-field--reverse': props.reverse,
          'v-field--single-line': props.singleLine,
          [`v-field--variant-${props.variant}`]: true
        }, themeClasses.value, textColorClasses.value],
        "style": [textColorStyles.value]
      }, attrs), {
        default: () => [_createVNode("div", {
          "class": ['v-field__control', backgroundColorClasses.value],
          "style": backgroundColorStyles.value,
          "onClick": onClick
        }, [_createVNode("div", {
          "class": "v-field__overlay"
        }, null), hasPrepend && _createVNode("div", {
          "class": "v-field__prepend-inner",
          "onClick": e => emit('click:prepend-inner', e)
        }, [props.prependInnerIcon && _createVNode(VIcon, {
          "icon": props.prependInnerIcon
        }, null, 8, ["icon"]), slots == null ? void 0 : (_slots$prependInner = slots.prependInner) == null ? void 0 : _slots$prependInner.call(slots, slotProps.value)], 8, ["onClick"]), _createVNode("div", {
          "class": "v-field__field"
        }, [['contained', 'filled'].includes(props.variant) && !props.singleLine && _createVNode(VFieldLabel, {
          "ref": floatingLabelRef,
          "floating": true
        }, {
          default: () => [label],
          _: 2
        }, 8, ["floating"]), _createVNode(VFieldLabel, {
          "ref": labelRef,
          "for": id.value
        }, {
          default: () => [label],
          _: 2
        }, 8, ["for"]), (_slots$default = slots.default) == null ? void 0 : _slots$default.call(slots, { ...slotProps.value,
          props: {
            id: id.value,
            class: 'v-field__input',
            onFocus: () => isFocused.value = true,
            onBlur: () => isFocused.value = false
          }
        })]), hasAppend && _createVNode("div", {
          "class": "v-field__append-inner",
          "onClick": e => emit('click:append-inner', e)
        }, [_createVNode(VExpandXTransition, null, {
          default: () => [hasClear && ((_inputRef$value = inputRef.value) == null ? void 0 : _inputRef$value.value) && _createVNode("div", {
            "class": "v-field__clearable"
          }, [_createVNode(VBtn, {
            "density": "compact",
            "icon": props.clearIcon,
            "tabindex": "-1",
            "variant": "text",
            "onClick": e => emit('click:clear', e)
          }, null, 8, ["icon", "onClick"])])]
        }), slots == null ? void 0 : (_slots$appendInner = slots.appendInner) == null ? void 0 : _slots$appendInner.call(slots, slotProps.value), props.appendInnerIcon && _createVNode(VIcon, {
          "icon": props.appendInnerIcon
        }, null, 8, ["icon"])], 8, ["onClick"]), _createVNode("div", {
          "class": "v-field__outline"
        }, [isOutlined && _createVNode(_Fragment, null, [_createVNode("div", {
          "class": "v-field__outline__start"
        }, null), _createVNode("div", {
          "class": "v-field__outline__notch"
        }, [!props.singleLine && _createVNode(VFieldLabel, {
          "ref": floatingLabelRef,
          "floating": true
        }, {
          default: () => [label],
          _: 2
        }, 8, ["floating"])]), _createVNode("div", {
          "class": "v-field__outline__end"
        }, null)]), ['plain', 'underlined'].includes(props.variant) && !props.singleLine && _createVNode(VFieldLabel, {
          "ref": floatingLabelRef,
          "floating": true
        }, {
          default: () => [label],
          _: 2
        }, 8, ["floating"])])], 14, ["onClick"])],
        prepend: slots.prepend && (() => {
          var _slots$prepend;

          return (_slots$prepend = slots.prepend) == null ? void 0 : _slots$prepend.call(slots, slotProps.value);
        }),
        append: slots.append && (() => {
          var _slots$append;

          return (_slots$append = slots.append) == null ? void 0 : _slots$append.call(slots, slotProps.value);
        }),
        details: hasDetails && (() => {
          var _slots$details;

          return _createVNode(_Fragment, null, [_createVNode(MaybeTransition, {
            "transition": props.transition
          }, {
            default: () => [_withDirectives(_createVNode("div", {
              "class": "v-field__details"
            }, [props.hint], 512), [[_vShow, props.hint && (props.persistentHint || slotProps.value.isFocused)]])]
          }, 8, ["transition"]), slots == null ? void 0 : (_slots$details = slots.details) == null ? void 0 : _slots$details.call(slots, slotProps.value)]);
        }),
        _: 2
      }, 16, ["class", "style"]);
    });
    return {
      inputRef,
      controlRef
    };
  }

}); // eslint-disable-next-line @typescript-eslint/no-redeclare
//# sourceMappingURL=VField.mjs.map