import { createVNode as _createVNode } from "vue";
// Utilities
import { defineComponent } from "../../util/index.mjs"; // Composables

import { makeThemeProps } from "../../composables/theme.mjs";
export default defineComponent({
  name: 'VFieldLabel',
  props: {
    floating: Boolean,
    ...makeThemeProps()
  },

  setup(props, {
    slots
  }) {
    return () => {
      var _slots$default;

      return _createVNode("label", {
        "class": ['v-field-label', {
          'v-field-label--floating': props.floating
        }],
        "aria-hidden": props.floating || undefined
      }, [(_slots$default = slots.default) == null ? void 0 : _slots$default.call(slots)], 10, ["aria-hidden"]);
    };
  }

});
//# sourceMappingURL=VFieldLabel.mjs.map