import { createVNode as _createVNode } from "vue";
import "./VInput.css"; // Utilities

import { defineComponent } from "../../util/index.mjs";
import { VIcon } from "../VIcon/index.mjs";
import { makeDensityProps, useDensity } from "../../composables/density.mjs";
export const VInput = defineComponent({
  name: 'VInput',
  props: {
    appendIcon: String,
    prependIcon: String,
    ...makeDensityProps()
  },
  emits: {
    'click:prepend': e => true,
    'click:append': e => true
  },

  setup(props, {
    slots,
    emit
  }) {
    const {
      densityClasses
    } = useDensity(props, 'v-input');
    return () => {
      var _slots$prepend, _slots$default, _slots$append, _slots$details;

      const hasPrepend = slots.prepend || props.prependIcon;
      const hasAppend = slots.append || props.appendIcon;
      return _createVNode("div", {
        "class": ['v-input', densityClasses.value]
      }, [hasPrepend && _createVNode("div", {
        "class": "v-input__prepend",
        "onClick": e => emit('click:prepend', e)
      }, [slots == null ? void 0 : (_slots$prepend = slots.prepend) == null ? void 0 : _slots$prepend.call(slots), props.prependIcon && _createVNode(VIcon, {
        "icon": props.prependIcon
      }, null, 8, ["icon"])], 8, ["onClick"]), (_slots$default = slots.default) == null ? void 0 : _slots$default.call(slots), hasAppend && _createVNode("div", {
        "class": "v-input__append",
        "onClick": e => emit('click:append', e)
      }, [slots == null ? void 0 : (_slots$append = slots.append) == null ? void 0 : _slots$append.call(slots), props.appendIcon && _createVNode(VIcon, {
        "icon": props.appendIcon
      }, null, 8, ["icon"])], 8, ["onClick"]), slots.details && _createVNode("div", {
        "class": "v-input__details"
      }, [(_slots$details = slots.details) == null ? void 0 : _slots$details.call(slots)])], 2);
    };
  }

});
/* eslint-disable-next-line @typescript-eslint/no-redeclare */
//# sourceMappingURL=VInput.mjs.map