// @ts-nocheck

/* eslint-disable */
// Styles
import "./VMessages.css"; // Mixins

import Colorable from "../../mixins/colorable/index.mjs";
import Themeable from "../../mixins/themeable/index.mjs"; // Types

import mixins from "../../util/mixins.mjs"; // Utilities

import { getSlot } from "../../util/helpers.mjs";
/* @vue/component */

export default mixins(Colorable, Themeable).extend({
  name: 'v-messages',
  props: {
    value: {
      type: Array,
      default: () => []
    }
  },
  methods: {
    genChildren() {
      return this.$createElement('transition-group', {
        staticClass: 'v-messages__wrapper',
        attrs: {
          name: 'message-transition',
          tag: 'div'
        }
      }, this.value.map(this.genMessage));
    },

    genMessage(message, key) {
      return this.$createElement('div', {
        staticClass: 'v-messages__message',
        key
      }, getSlot(this, 'default', {
        message,
        key
      }) || [message]);
    }

  },

  render(h) {
    return h('div', this.setTextColor(this.color, {
      staticClass: 'v-messages',
      class: this.themeClasses
    }), [this.genChildren()]);
  }

});
//# sourceMappingURL=VMessages.mjs.map