/** Convert a point in local space to viewport space */
export function elementToViewport(point, offset) {
  return {
    x: point.x + offset.x,
    y: point.y + offset.y
  };
}
/** Convert a point in viewport space to local space */

export function viewportToElement(point, offset) {
  return {
    x: point.x - offset.x,
    y: point.y - offset.y
  };
}
/** Get the difference between two points */

export function getOffset(a, b) {
  return {
    x: a.x - b.x,
    y: a.y - b.y
  };
}
/** Convert an anchor object to a point in local space */

export function anchorToPoint(anchor, box) {
  if (anchor.side === 'top' || anchor.side === 'bottom') {
    const {
      side,
      align
    } = anchor;
    const x = align === 'start' ? 0 : align === 'center' ? box.width / 2 : align === 'end' ? box.width : align;
    const y = side === 'top' ? 0 : side === 'bottom' ? box.height : side;
    return elementToViewport({
      x,
      y
    }, box);
  } else if (anchor.side === 'start' || anchor.side === 'end') {
    const {
      side,
      align
    } = anchor;
    const x = side === 'start' ? 0 : side === 'end' ? box.width : side;
    const y = align === 'top' ? 0 : align === 'center' ? box.height / 2 : align === 'bottom' ? box.height : align;
    return elementToViewport({
      x,
      y
    }, box);
  }

  return elementToViewport({
    x: box.width / 2,
    y: box.height / 2
  }, box);
}
//# sourceMappingURL=point.mjs.map