// @ts-nocheck

/* eslint-disable */
// Styles
import "./VVirtualScroll.css"; // Mixins

import Measurable from "../../mixins/measurable.mjs"; // Directives

import Scroll from "../../directives/scroll/index.mjs"; // Utilities

import { convertToUnit, getSlot } from "../../util/helpers.mjs"; // Types

export default Measurable.extend({
  name: 'v-virtual-scroll',
  directives: {
    Scroll
  },
  props: {
    bench: {
      type: [Number, String],
      default: 0
    },
    itemHeight: {
      type: [Number, String],
      required: true
    },
    items: {
      type: Array,
      default: () => []
    }
  },
  data: () => ({
    first: 0,
    last: 0,
    scrollTop: 0
  }),
  computed: {
    __bench() {
      return parseInt(this.bench, 10);
    },

    __itemHeight() {
      return parseInt(this.itemHeight, 10);
    },

    firstToRender() {
      return Math.max(0, this.first - this.__bench);
    },

    lastToRender() {
      return Math.min(this.items.length, this.last + this.__bench);
    }

  },
  watch: {
    height: 'onScroll',
    itemHeight: 'onScroll'
  },

  mounted() {
    this.last = this.getLast(0);
  },

  methods: {
    getChildren() {
      return this.items.slice(this.firstToRender, this.lastToRender).map(this.genChild);
    },

    genChild(item, index) {
      index += this.firstToRender;
      const top = convertToUnit(index * this.__itemHeight);
      return this.$createElement('div', {
        staticClass: 'v-virtual-scroll__item',
        style: {
          top
        },
        key: index
      }, getSlot(this, 'default', {
        index,
        item
      }));
    },

    getFirst() {
      return Math.floor(this.scrollTop / this.__itemHeight);
    },

    getLast(first) {
      const height = parseInt(this.height || 0, 10) || this.$el.clientHeight;
      return first + Math.ceil(height / this.__itemHeight);
    },

    onScroll() {
      this.scrollTop = this.$el.scrollTop;
      this.first = this.getFirst();
      this.last = this.getLast(this.first);
    }

  },

  render(h) {
    const content = h('div', {
      staticClass: 'v-virtual-scroll__container',
      style: {
        height: convertToUnit(this.items.length * this.__itemHeight)
      }
    }, this.getChildren());
    return h('div', {
      staticClass: 'v-virtual-scroll',
      style: this.measurableStyles,
      directives: [{
        name: 'scroll',
        modifiers: {
          self: true
        },
        value: this.onScroll
      }],
      on: this.$listeners
    }, [content]);
  }

});
//# sourceMappingURL=VVirtualScroll.mjs.map