// Types
function mounted(el, binding) {
  var _modifierKeys$attr, _modifierKeys$char, _modifierKeys$child, _modifierKeys$sub;

  const modifiers = binding.modifiers || {};
  const value = binding.value;
  const {
    once,
    immediate,
    ...modifierKeys
  } = modifiers;
  const defaultValue = !Object.keys(modifierKeys).length;
  const {
    handler,
    options
  } = typeof value === 'object' ? value : {
    handler: value,
    options: {
      attributes: (_modifierKeys$attr = modifierKeys == null ? void 0 : modifierKeys.attr) != null ? _modifierKeys$attr : defaultValue,
      characterData: (_modifierKeys$char = modifierKeys == null ? void 0 : modifierKeys.char) != null ? _modifierKeys$char : defaultValue,
      childList: (_modifierKeys$child = modifierKeys == null ? void 0 : modifierKeys.child) != null ? _modifierKeys$child : defaultValue,
      subtree: (_modifierKeys$sub = modifierKeys == null ? void 0 : modifierKeys.sub) != null ? _modifierKeys$sub : defaultValue
    }
  };
  const observer = new MutationObserver((mutations = [], observer) => {
    handler == null ? void 0 : handler(mutations, observer);
    if (once) unmounted(el);
  });
  if (immediate) handler == null ? void 0 : handler([], observer);
  el._mutate = {
    observer
  };
  observer.observe(el, options);
}

function unmounted(el) {
  var _el$_mutate, _el$_mutate$observer;

  el == null ? void 0 : (_el$_mutate = el._mutate) == null ? void 0 : (_el$_mutate$observer = _el$_mutate.observer) == null ? void 0 : _el$_mutate$observer.disconnect();
  delete el._mutate;
}

export const Mutate = {
  mounted,
  unmounted
};
export default Mutate;
//# sourceMappingURL=index.mjs.map