function mounted(el, binding) {
  var _binding$modifiers, _binding$modifiers2;

  const handler = binding.value;
  const options = {
    passive: !((_binding$modifiers = binding.modifiers) != null && _binding$modifiers.active)
  };
  window.addEventListener('resize', handler, options);
  el._onResize = {
    handler,
    options
  };

  if (!((_binding$modifiers2 = binding.modifiers) != null && _binding$modifiers2.quiet)) {
    handler();
  }
}

function unmounted(el) {
  if (!el._onResize) return;
  const {
    handler,
    options
  } = el._onResize;
  window.removeEventListener('resize', handler, options);
  delete el._onResize;
}

export const Resize = {
  mounted,
  unmounted
};
export default Resize;
//# sourceMappingURL=index.mjs.map