import { createVNode as _createVNode, mergeProps as _mergeProps, resolveDirective as _resolveDirective } from "vue";
// Styles
import "./VAppBar.css"; // Components

import { filterToolbarProps, makeVToolbarProps, VToolbar } from "../VToolbar/VToolbar.mjs"; // Composables

import { makeLayoutItemProps, useLayoutItem } from "../../composables/layout.mjs";
import { useProxiedModel } from "../../composables/proxiedModel.mjs"; // Utilities

import { computed, ref, toRef } from 'vue';
import { defineComponent } from "../../util/index.mjs"; // Types

export const VAppBar = defineComponent({
  name: 'VAppBar',
  props: {
    // TODO: Implement scrolling techniques
    // hideOnScroll: Boolean
    // invertedScroll: Boolean
    // collapseOnScroll: Boolean
    // elevateOnScroll: Boolean
    // shrinkOnScroll: Boolean
    // fadeImageOnScroll: Boolean
    modelValue: {
      type: Boolean,
      default: true
    },
    location: {
      type: String,
      default: 'top',
      validator: value => ['top', 'bottom'].includes(value)
    },
    ...makeVToolbarProps(),
    ...makeLayoutItemProps(),
    height: {
      type: [Number, String],
      default: 64
    }
  },
  emits: {
    'update:modelValue': value => true
  },

  setup(props, _ref) {
    let {
      slots
    } = _ref;
    const vToolbarRef = ref();
    const isActive = useProxiedModel(props, 'modelValue');
    const height = computed(() => {
      var _vToolbarRef$value$co, _vToolbarRef$value, _vToolbarRef$value$ex, _vToolbarRef$value2;

      const height = (_vToolbarRef$value$co = (_vToolbarRef$value = vToolbarRef.value) == null ? void 0 : _vToolbarRef$value.contentHeight) != null ? _vToolbarRef$value$co : 0;
      const extensionHeight = (_vToolbarRef$value$ex = (_vToolbarRef$value2 = vToolbarRef.value) == null ? void 0 : _vToolbarRef$value2.extensionHeight) != null ? _vToolbarRef$value$ex : 0;
      return height + extensionHeight;
    });
    const {
      layoutItemStyles
    } = useLayoutItem({
      id: props.name,
      order: computed(() => parseInt(props.order, 10)),
      position: toRef(props, 'location'),
      layoutSize: height,
      elementSize: height,
      active: isActive,
      absolute: toRef(props, 'absolute')
    });
    return () => {
      const [toolbarProps] = filterToolbarProps(props);
      return _createVNode(VToolbar, _mergeProps({
        "ref": vToolbarRef,
        "class": ['v-app-bar', {
          'v-app-bar--bottom': props.location === 'bottom'
        }],
        "style": { ...layoutItemStyles.value,
          height: undefined
        }
      }, toolbarProps), slots);
    };
  }

});
//# sourceMappingURL=VAppBar.mjs.map