import { createVNode as _createVNode } from "vue";
// Styles
import "./VAvatar.css"; // Components

import { VIcon } from "../VIcon/index.mjs";
import { VImg } from "../VImg/index.mjs"; // Composables

import { makeDensityProps, useDensity } from "../../composables/density.mjs";
import { makeRoundedProps, useRounded } from "../../composables/rounded.mjs";
import { makeSizeProps, useSize } from "../../composables/size.mjs";
import { makeTagProps } from "../../composables/tag.mjs";
import { useBackgroundColor } from "../../composables/color.mjs";
import { IconValue } from "../../composables/icons.mjs"; // Utilities

import { defineComponent, propsFactory, useRender } from "../../util/index.mjs";
import { toRef } from 'vue';
export const makeVAvatarProps = propsFactory({
  color: String,
  start: Boolean,
  end: Boolean,
  icon: IconValue,
  image: String,
  ...makeDensityProps(),
  ...makeRoundedProps(),
  ...makeSizeProps(),
  ...makeTagProps()
});
export const VAvatar = defineComponent({
  name: 'VAvatar',
  props: makeVAvatarProps(),

  setup(props, _ref) {
    let {
      slots
    } = _ref;
    const {
      backgroundColorClasses,
      backgroundColorStyles
    } = useBackgroundColor(toRef(props, 'color'));
    const {
      densityClasses
    } = useDensity(props);
    const {
      roundedClasses
    } = useRounded(props);
    const {
      sizeClasses,
      sizeStyles
    } = useSize(props);
    useRender(() => {
      var _slots$default;

      return _createVNode(props.tag, {
        "class": ['v-avatar', {
          'v-avatar--start': props.start,
          'v-avatar--end': props.end
        }, backgroundColorClasses.value, densityClasses.value, roundedClasses.value, sizeClasses.value],
        "style": [backgroundColorStyles.value, sizeStyles.value]
      }, {
        default: () => [props.image ? _createVNode(VImg, {
          "src": props.image,
          "alt": ""
        }, null) : props.icon ? _createVNode(VIcon, {
          "icon": props.icon
        }, null) : (_slots$default = slots.default) == null ? void 0 : _slots$default.call(slots)]
      });
    });
    return {};
  }

});
//# sourceMappingURL=VAvatar.mjs.map