import { createVNode as _createVNode, Fragment as _Fragment } from "vue";
// Styles
import "./VBanner.css"; // Components

import { VBannerActions } from "./VBannerActions.mjs";
import { VBannerAvatar } from "./VBannerAvatar.mjs";
import { VBannerIcon } from "./VBannerIcon.mjs";
import { VBannerText } from "./VBannerText.mjs"; // Composables

import { makeBorderProps, useBorder } from "../../composables/border.mjs";
import { makeDensityProps, useDensity } from "../../composables/density.mjs";
import { makeDimensionProps, useDimension } from "../../composables/dimensions.mjs";
import { makeElevationProps, useElevation } from "../../composables/elevation.mjs";
import { makeLocationProps, useLocation } from "../../composables/location.mjs";
import { makePositionProps, usePosition } from "../../composables/position.mjs";
import { makeRoundedProps, useRounded } from "../../composables/rounded.mjs";
import { makeTagProps } from "../../composables/tag.mjs";
import { makeThemeProps, provideTheme } from "../../composables/theme.mjs";
import { provideDefaults } from "../../composables/defaults.mjs";
import { useDisplay } from "../../composables/display.mjs";
import { IconValue } from "../../composables/icons.mjs"; // Utilities

import { defineComponent, useRender } from "../../util/index.mjs";
import { toRef } from 'vue'; // Types

export const VBanner = defineComponent({
  name: 'VBanner',
  props: {
    avatar: String,
    color: String,
    icon: IconValue,
    lines: String,
    stacked: Boolean,
    sticky: Boolean,
    text: String,
    ...makeBorderProps(),
    ...makeDensityProps(),
    ...makeDimensionProps(),
    ...makeElevationProps(),
    ...makeLocationProps(),
    ...makePositionProps(),
    ...makeRoundedProps(),
    ...makeTagProps(),
    ...makeThemeProps()
  },

  setup(props, _ref) {
    let {
      slots
    } = _ref;
    const {
      borderClasses
    } = useBorder(props);
    const {
      densityClasses
    } = useDensity(props);
    const {
      mobile
    } = useDisplay();
    const {
      dimensionStyles
    } = useDimension(props);
    const {
      elevationClasses
    } = useElevation(props);
    const {
      locationStyles
    } = useLocation(props);
    const {
      positionClasses
    } = usePosition(props);
    const {
      roundedClasses
    } = useRounded(props);
    const {
      themeClasses
    } = provideTheme(props);
    const color = toRef(props, 'color');
    const density = toRef(props, 'density');
    provideDefaults({
      VBannerActions: {
        color,
        density
      },
      VBannerAvatar: {
        density,
        image: toRef(props, 'avatar')
      },
      VBannerIcon: {
        color,
        density,
        icon: toRef(props, 'icon')
      }
    });
    useRender(() => {
      var _slots$default;

      const hasText = !!(props.text || slots.text);
      const hasPrepend = !!(slots.prepend || props.avatar || props.icon);
      return _createVNode(props.tag, {
        "class": ['v-banner', {
          'v-banner--stacked': props.stacked || mobile.value,
          'v-banner--sticky': props.sticky,
          [`v-banner--${props.lines}-line`]: !!props.lines
        }, borderClasses.value, densityClasses.value, elevationClasses.value, positionClasses.value, roundedClasses.value, themeClasses.value],
        "style": [dimensionStyles.value, locationStyles.value],
        "role": "banner"
      }, {
        default: () => [hasPrepend && _createVNode(_Fragment, null, [slots.prepend ? _createVNode("div", {
          "class": "v-banner__prepend"
        }, [slots.prepend()]) : props.avatar ? _createVNode(VBannerAvatar, null, null) : props.icon ? _createVNode(VBannerIcon, null, null) : undefined]), hasText && _createVNode(VBannerText, null, {
          default: () => [slots.text ? slots.text() : props.text]
        }), (_slots$default = slots.default) == null ? void 0 : _slots$default.call(slots), slots.actions && _createVNode(VBannerActions, null, {
          default: () => [slots.actions()]
        })]
      });
    });
  }

});
//# sourceMappingURL=VBanner.mjs.map