// @ts-nocheck

/* eslint-disable */
import Vue from 'vue';
import { getObjectValueByPath } from "../../util/helpers.mjs";
export default Vue.extend({
  name: 'row',
  functional: true,
  props: {
    headers: Array,
    hideDefaultHeader: Boolean,
    index: Number,
    item: Object,
    rtl: Boolean
  },

  render(h, _ref) {
    let {
      props,
      slots,
      data
    } = _ref;
    const computedSlots = slots();
    const columns = props.headers.map(header => {
      const classes = {
        'v-data-table__mobile-row': true
      };
      const children = [];
      const value = getObjectValueByPath(props.item, header.value);
      const slotName = header.value;
      const scopedSlot = data.scopedSlots && data.scopedSlots[slotName];
      const regularSlot = computedSlots[slotName];

      if (scopedSlot) {
        children.push(scopedSlot({
          item: props.item,
          isMobile: true,
          header,
          index: props.index,
          value
        }));
      } else if (regularSlot) {
        children.push(regularSlot);
      } else {
        children.push(value == null ? value : String(value));
      }

      const mobileRowChildren = [h('div', {
        staticClass: 'v-data-table__mobile-row__cell'
      }, children)];

      if (header.value !== 'dataTableSelect' && !props.hideDefaultHeader) {
        mobileRowChildren.unshift(h('div', {
          staticClass: 'v-data-table__mobile-row__header'
        }, [header.text]));
      }

      return h('td', {
        class: classes
      }, mobileRowChildren);
    });
    return h('tr', { ...data,
      staticClass: 'v-data-table__mobile-table-row'
    }, columns);
  }

});
//# sourceMappingURL=MobileRow.mjs.map