import { createVNode as _createVNode } from "vue";
// Styles
import "./VIcon.css"; // Composables

import { makeSizeProps, useSize } from "../../composables/size.mjs";
import { makeTagProps } from "../../composables/tag.mjs";
import { IconValue, useIcon } from "../../composables/icons.mjs";
import { useTextColor } from "../../composables/color.mjs";
import { makeThemeProps, provideTheme } from "../../composables/theme.mjs"; // Utilities

import { computed, toRef } from 'vue';
import { convertToUnit, defineComponent, flattenFragments, propsFactory } from "../../util/index.mjs"; // Types

export const makeVIconProps = propsFactory({
  color: String,
  start: Boolean,
  end: Boolean,
  icon: IconValue,
  ...makeSizeProps(),
  ...makeTagProps({
    tag: 'i'
  }),
  ...makeThemeProps()
}, 'v-icon');
export const VIcon = defineComponent({
  name: 'VIcon',
  props: makeVIconProps(),

  setup(props, _ref) {
    let {
      attrs,
      slots
    } = _ref;
    let slotIcon;

    if (slots.default) {
      slotIcon = computed(() => {
        var _slots$default, _flattenFragments$fil;

        const slot = (_slots$default = slots.default) == null ? void 0 : _slots$default.call(slots);
        if (!slot) return;
        return (_flattenFragments$fil = flattenFragments(slot).filter(node => node.children && typeof node.children === 'string')[0]) == null ? void 0 : _flattenFragments$fil.children;
      });
    }

    const {
      themeClasses
    } = provideTheme(props);
    const {
      iconData
    } = useIcon(slotIcon || props);
    const {
      sizeClasses
    } = useSize(props);
    const {
      textColorClasses,
      textColorStyles
    } = useTextColor(toRef(props, 'color'));
    return () => {
      return _createVNode(iconData.value.component, {
        "tag": props.tag,
        "icon": iconData.value.icon,
        "class": ['v-icon', 'notranslate', sizeClasses.value, textColorClasses.value, themeClasses.value, {
          'v-icon--clickable': !!attrs.onClick,
          'v-icon--start': props.start,
          'v-icon--end': props.end
        }],
        "style": [!sizeClasses.value ? {
          fontSize: convertToUnit(props.size),
          width: convertToUnit(props.size),
          height: convertToUnit(props.size)
        } : undefined, textColorStyles.value],
        "aria-hidden": "true"
      }, null);
    };
  }

});
//# sourceMappingURL=VIcon.mjs.map