import { createVNode as _createVNode } from "vue";
// Styles
import "./VLayoutItem.css"; // Composables

import { makeLayoutItemProps, useLayoutItem } from "../../composables/layout.mjs"; // Utilities

import { computed, toRef } from 'vue';
import { defineComponent } from "../../util/index.mjs"; // Types

export const VLayoutItem = defineComponent({
  name: 'VLayoutItem',
  props: {
    position: {
      type: String,
      required: true
    },
    size: {
      type: [Number, String],
      default: 300
    },
    modelValue: Boolean,
    ...makeLayoutItemProps()
  },

  setup(props, _ref) {
    let {
      slots
    } = _ref;
    const {
      layoutItemStyles
    } = useLayoutItem({
      id: props.name,
      order: computed(() => parseInt(props.order, 10)),
      position: toRef(props, 'position'),
      elementSize: toRef(props, 'size'),
      layoutSize: toRef(props, 'size'),
      active: toRef(props, 'modelValue'),
      absolute: toRef(props, 'absolute')
    });
    return () => {
      var _slots$default;

      return _createVNode("div", {
        "class": ['v-layout-item'],
        "style": layoutItemStyles.value
      }, [(_slots$default = slots.default) == null ? void 0 : _slots$default.call(slots)]);
    };
  }

});
//# sourceMappingURL=VLayoutItem.mjs.map