import { mergeProps as _mergeProps, resolveDirective as _resolveDirective, createVNode as _createVNode } from "vue";
// Components
import { VDivider } from "../VDivider/index.mjs";
import { VListGroup } from "./VListGroup.mjs";
import { VListItem } from "./VListItem.mjs";
import { VListSubheader } from "./VListSubheader.mjs"; // Utilities

import { genericComponent } from "../../util/index.mjs";
import { createList } from "./list.mjs"; // Types

export const VListChildren = genericComponent()({
  name: 'VListChildren',
  props: {
    items: Array
  },

  setup(props, _ref) {
    let {
      slots
    } = _ref;
    createList();
    return () => {
      var _slots$default, _slots$default2, _props$items;

      return (_slots$default = (_slots$default2 = slots.default) == null ? void 0 : _slots$default2.call(slots)) != null ? _slots$default : (_props$items = props.items) == null ? void 0 : _props$items.map(_ref2 => {
        let {
          children,
          props: itemProps,
          type,
          originalItem: item
        } = _ref2;
        if (type === 'divider') return _createVNode(VDivider, itemProps, null);
        if (type === 'subheader') return _createVNode(VListSubheader, itemProps, slots);
        const slotsWithItem = {
          subtitle: slots.subtitle ? slotProps => {
            var _slots$subtitle;

            return (_slots$subtitle = slots.subtitle) == null ? void 0 : _slots$subtitle.call(slots, { ...slotProps,
              item
            });
          } : undefined,
          prepend: slots.prepend ? slotProps => {
            var _slots$prepend;

            return (_slots$prepend = slots.prepend) == null ? void 0 : _slots$prepend.call(slots, { ...slotProps,
              item
            });
          } : undefined,
          append: slots.append ? slotProps => {
            var _slots$append;

            return (_slots$append = slots.append) == null ? void 0 : _slots$append.call(slots, { ...slotProps,
              item
            });
          } : undefined,
          default: slots.default ? slotProps => {
            var _slots$default3;

            return (_slots$default3 = slots.default) == null ? void 0 : _slots$default3.call(slots, { ...slotProps,
              item
            });
          } : undefined,
          title: slots.title ? slotProps => {
            var _slots$title;

            return (_slots$title = slots.title) == null ? void 0 : _slots$title.call(slots, { ...slotProps,
              item
            });
          } : undefined
        };
        return children ? _createVNode(VListGroup, {
          "value": itemProps == null ? void 0 : itemProps.value
        }, {
          activator: _ref3 => {
            let {
              props: activatorProps
            } = _ref3;
            return slots.header ? slots.header({ ...itemProps,
              ...activatorProps
            }) : _createVNode(VListItem, _mergeProps(itemProps, activatorProps), slotsWithItem);
          },
          default: () => _createVNode(VListChildren, {
            "items": children
          }, slots)
        }) : slots.item ? slots.item(itemProps) : _createVNode(VListItem, itemProps, slotsWithItem);
      });
    };
  }

});
//# sourceMappingURL=VListChildren.mjs.map