import { withDirectives as _withDirectives, vShow as _vShow, createVNode as _createVNode } from "vue";
// Components
import { VDefaultsProvider } from "../VDefaultsProvider/index.mjs";
import { VExpandTransition } from "../transitions/index.mjs"; // Composables

import { useList } from "./list.mjs";
import { makeTagProps } from "../../composables/tag.mjs";
import { useNestedGroupActivator, useNestedItem } from "../../composables/nested/nested.mjs";
import { IconValue } from "../../composables/icons.mjs"; // Utilities

import { computed, toRef } from 'vue';
import { defineComponent, genericComponent } from "../../util/index.mjs"; // Types

const VListGroupActivator = defineComponent({
  name: 'VListGroupActivator',

  setup(_, _ref) {
    let {
      slots
    } = _ref;
    useNestedGroupActivator();
    return () => {
      var _slots$default;

      return (_slots$default = slots.default) == null ? void 0 : _slots$default.call(slots);
    };
  }

});
export const VListGroup = genericComponent()({
  name: 'VListGroup',
  props: {
    activeColor: String,
    color: String,
    collapseIcon: {
      type: IconValue,
      default: '$collapse'
    },
    expandIcon: {
      type: IconValue,
      default: '$expand'
    },
    value: null,
    ...makeTagProps()
  },

  setup(props, _ref2) {
    let {
      slots
    } = _ref2;
    const {
      isOpen,
      open
    } = useNestedItem(toRef(props, 'value'), true);
    const list = useList();

    const onClick = e => {
      open(!isOpen.value, e);
    };

    const activatorProps = computed(() => {
      var _props$activeColor;

      return {
        onClick,
        active: isOpen.value,
        appendIcon: isOpen.value ? props.collapseIcon : props.expandIcon,
        class: 'v-list-group__header',
        color: isOpen.value ? (_props$activeColor = props.activeColor) != null ? _props$activeColor : props.color : undefined
      };
    });
    return () => {
      var _slots$default2;

      return _createVNode(props.tag, {
        "class": ['v-list-group', {
          'v-list-group--prepend': list == null ? void 0 : list.hasPrepend.value
        }]
      }, {
        default: () => [slots.activator && _createVNode(VDefaultsProvider, {
          "defaults": {
            VListItemIcon: {
              color: activatorProps.value.color
            }
          }
        }, {
          default: () => [_createVNode(VListGroupActivator, null, {
            default: () => [slots.activator({
              props: activatorProps.value,
              isOpen
            })]
          })]
        }), _createVNode(VExpandTransition, null, {
          default: () => [_withDirectives(_createVNode("div", {
            "class": "v-list-group__items"
          }, [(_slots$default2 = slots.default) == null ? void 0 : _slots$default2.call(slots)]), [[_vShow, isOpen.value]])]
        })]
      });
    };
  }

});
//# sourceMappingURL=VListGroup.mjs.map