import { createVNode as _createVNode } from "vue";
// Composables
import { makeTagProps } from "../../composables/tag.mjs";
import { useTextColor } from "../../composables/color.mjs"; // Utilities

import { toRef } from 'vue';
import { defineComponent } from "../../util/index.mjs";
export const VListSubheader = defineComponent({
  name: 'VListSubheader',
  props: {
    color: String,
    inset: Boolean,
    sticky: Boolean,
    title: String,
    ...makeTagProps()
  },

  setup(props, _ref) {
    let {
      slots
    } = _ref;
    const {
      textColorClasses,
      textColorStyles
    } = useTextColor(toRef(props, 'color'));
    return () => {
      var _slots$default, _slots$default2;

      const hasText = !!(slots.default || props.title);
      return _createVNode(props.tag, {
        "class": ['v-list-subheader', {
          'v-list-subheader--inset': props.inset,
          'v-list-subheader--sticky': props.sticky
        }, textColorClasses.value],
        "style": {
          textColorStyles
        }
      }, {
        default: () => [hasText && _createVNode("div", {
          "class": "v-list-subheader__text"
        }, [(_slots$default = (_slots$default2 = slots.default) == null ? void 0 : _slots$default2.call(slots)) != null ? _slots$default : props.title])]
      });
    };
  }

});
//# sourceMappingURL=VListSubheader.mjs.map