import { createVNode as _createVNode, mergeProps as _mergeProps, resolveDirective as _resolveDirective } from "vue";
import { Transition } from 'vue';
import { acceleratedEasing, deceleratedEasing, defineComponent, nullifyTransforms, standardEasing } from "../../util/index.mjs";
export const VDialogTransition = defineComponent({
  name: 'VDialogTransition',
  props: {
    target: Object
  },

  setup(props, _ref) {
    let {
      slots
    } = _ref;
    const functions = {
      onBeforeEnter(el) {
        el.style.pointerEvents = 'none';
      },

      async onEnter(el, done) {
        var _getChildren;

        await new Promise(resolve => requestAnimationFrame(resolve));
        const {
          x,
          y,
          sx,
          sy,
          speed
        } = getDimensions(props.target, el);
        const animation = el.animate([{
          transform: `translate(${x}px, ${y}px) scale(${sx}, ${sy})`,
          opacity: 0
        }, {
          transform: ''
        }], {
          duration: 225 * speed,
          easing: deceleratedEasing
        });
        (_getChildren = getChildren(el)) == null ? void 0 : _getChildren.forEach(el => {
          el.animate([{
            opacity: 0
          }, {
            opacity: 0,
            offset: 0.33
          }, {
            opacity: 1
          }], {
            duration: 225 * 2 * speed,
            easing: standardEasing
          });
        });
        animation.finished.then(() => done());
      },

      onAfterEnter(el) {
        el.style.removeProperty('pointer-events');
      },

      onBeforeLeave(el) {
        el.style.pointerEvents = 'none';
      },

      async onLeave(el, done) {
        var _getChildren2;

        await new Promise(resolve => requestAnimationFrame(resolve));
        const {
          x,
          y,
          sx,
          sy,
          speed
        } = getDimensions(props.target, el);
        const animation = el.animate([{
          transform: ''
        }, {
          transform: `translate(${x}px, ${y}px) scale(${sx}, ${sy})`,
          opacity: 0
        }], {
          duration: 125 * speed,
          easing: acceleratedEasing
        });
        animation.finished.then(() => done());
        (_getChildren2 = getChildren(el)) == null ? void 0 : _getChildren2.forEach(el => {
          el.animate([{}, {
            opacity: 0,
            offset: 0.2
          }, {
            opacity: 0
          }], {
            duration: 125 * 2 * speed,
            easing: standardEasing
          });
        });
      },

      onAfterLeave(el) {
        el.style.removeProperty('pointer-events');
      }

    };
    return () => {
      return props.target ? _createVNode(Transition, _mergeProps({
        "name": "dialog-transition"
      }, functions, {
        "css": false
      }), slots) : _createVNode(Transition, {
        "name": "dialog-transition"
      }, slots);
    };
  }

});
/** Animatable children (card, sheet, list) */

function getChildren(el) {
  var _el$querySelector;

  const els = (_el$querySelector = el.querySelector(':scope > .v-card, :scope > .v-sheet, :scope > .v-list')) == null ? void 0 : _el$querySelector.children;
  return els && [...els];
}

function getDimensions(target, el) {
  const targetBox = target.getBoundingClientRect();
  const elBox = nullifyTransforms(el);
  const [originX, originY] = getComputedStyle(el).transformOrigin.split(' ').map(v => parseFloat(v));
  const [anchorSide, anchorOffset] = getComputedStyle(el).getPropertyValue('--v-overlay-anchor-origin').split(' ');
  let offsetX = targetBox.left + targetBox.width / 2;

  if (anchorSide === 'left' || anchorOffset === 'left') {
    offsetX -= targetBox.width / 2;
  } else if (anchorSide === 'right' || anchorOffset === 'right') {
    offsetX += targetBox.width / 2;
  }

  let offsetY = targetBox.top + targetBox.height / 2;

  if (anchorSide === 'top' || anchorOffset === 'top') {
    offsetY -= targetBox.height / 2;
  } else if (anchorSide === 'bottom' || anchorOffset === 'bottom') {
    offsetY += targetBox.height / 2;
  }

  const tsx = targetBox.width / elBox.width;
  const tsy = targetBox.height / elBox.height;
  const maxs = Math.max(1, tsx, tsy);
  const sx = tsx / maxs;
  const sy = tsy / maxs; // Animate elements larger than 12% of the screen area up to 1.5x slower

  const asa = elBox.width * elBox.height / (window.innerWidth * window.innerHeight);
  const speed = asa > 0.12 ? Math.min(1.5, (asa - 0.12) * 10 + 1) : 1;
  return {
    x: offsetX - (originX + elBox.left),
    y: offsetY - (originY + elBox.top),
    sx,
    sy,
    speed
  };
}
//# sourceMappingURL=dialog-transition.mjs.map