/* eslint-disable max-statements */

/* eslint-disable no-labels */
// Utilities
import { getPropertyFromItem, propsFactory, wrapInArray } from "../util/index.mjs";
import { computed, unref } from 'vue'; // Types

// Composables
export const defaultFilter = (value, query, item) => {
  if (value == null || query == null) return -1;
  return value.toString().toLocaleLowerCase().indexOf(query.toString().toLocaleLowerCase());
};
export const makeFilterProps = propsFactory({
  customFilter: Function,
  customKeyFilter: Object,
  filterKeys: [Array, String],
  filterMode: {
    type: String,
    default: 'intersection'
  },
  noFilter: Boolean
}, 'filter');
export function filterItems(items, query, options) {
  var _options$default, _options$customKeyFil;

  const array = []; // always ensure we fall back to a functioning filter

  const filter = (_options$default = options == null ? void 0 : options.default) != null ? _options$default : defaultFilter;
  const keys = options != null && options.filterKeys ? wrapInArray(options.filterKeys) : false;
  const customFiltersLength = Object.keys((_options$customKeyFil = options == null ? void 0 : options.customKeyFilter) != null ? _options$customKeyFil : {}).length;
  if (!(items != null && items.length)) return array;

  loop: for (let i = 0; i < items.length; i++) {
    const item = items[i];
    const customMatches = {};
    const defaultMatches = {};
    let match = -1;

    if (query && !(options != null && options.noFilter)) {
      if (typeof item === 'object') {
        const filterKeys = keys || Object.keys(item);

        for (const key of filterKeys) {
          var _options$customKeyFil2;

          const value = getPropertyFromItem(item, key, item);
          const keyFilter = options == null ? void 0 : (_options$customKeyFil2 = options.customKeyFilter) == null ? void 0 : _options$customKeyFil2[key];
          match = keyFilter ? keyFilter(value, query, item) : filter(value, query, item);

          if (match !== -1 && match !== false) {
            if (keyFilter) customMatches[key] = match;else defaultMatches[key] = match;
          } else if ((options == null ? void 0 : options.filterMode) === 'every') {
            continue loop;
          }
        }
      } else {
        match = filter(item, query, item);

        if (match !== -1 && match !== false) {
          defaultMatches.title = match;
        }
      }

      const defaultMatchesLength = Object.keys(defaultMatches).length;
      const customMatchesLength = Object.keys(customMatches).length;
      if (!defaultMatchesLength && !customMatchesLength) continue;
      if ((options == null ? void 0 : options.filterMode) === 'union' && customMatchesLength !== customFiltersLength && !defaultMatchesLength) continue;
      if ((options == null ? void 0 : options.filterMode) === 'intersection' && (customMatchesLength !== customFiltersLength || !defaultMatchesLength)) continue;
    }

    array.push({
      index: i,
      matches: { ...defaultMatches,
        ...customMatches
      }
    });
  }

  return array;
}
export function useFilter(props, items, query) {
  const strQuery = computed(() => typeof (query == null ? void 0 : query.value) !== 'string' && typeof (query == null ? void 0 : query.value) !== 'number' ? '' : String(query.value));
  const filteredItems = computed(() => {
    const transformedItems = unref(items);
    const matches = filterItems(transformedItems, strQuery.value, {
      customKeyFilter: props.customKeyFilter,
      default: props.customFilter,
      filterKeys: props.filterKeys,
      filterMode: props.filterMode,
      noFilter: props.noFilter
    });
    return matches.map(_ref => {
      let {
        index,
        matches
      } = _ref;
      return {
        item: transformedItems[index],
        matches
      };
    });
  });
  return {
    filteredItems
  };
}
//# sourceMappingURL=filter.mjs.map