// Components
import { useProxiedModel } from "./proxiedModel.mjs"; // Utilities

import { computed } from 'vue';
import { getCurrentInstanceName, propsFactory } from "../util/index.mjs"; // Types

// Composables
export const makeFocusProps = propsFactory({
  focused: Boolean
}, 'focus');
export function useFocus(props) {
  let name = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : getCurrentInstanceName();
  const isFocused = useProxiedModel(props, 'focused');
  const focusClasses = computed(() => {
    return {
      [`${name}--focused`]: isFocused.value
    };
  });

  function focus() {
    isFocused.value = true;
  }

  function blur() {
    isFocused.value = false;
  }

  return {
    focusClasses,
    isFocused,
    focus,
    blur
  };
}
//# sourceMappingURL=focus.mjs.map