// Utilities
import { getCurrentInstance, IN_BROWSER, propsFactory } from "../util/index.mjs";
import { computed, nextTick, onScopeDispose, resolveDynamicComponent, toRef } from 'vue'; // Types

export function useRoute() {
  const vm = getCurrentInstance('useRoute');
  return computed(() => {
    var _vm$proxy;

    return vm == null ? void 0 : (_vm$proxy = vm.proxy) == null ? void 0 : _vm$proxy.$route;
  });
}
export function useRouter() {
  var _getCurrentInstance, _getCurrentInstance$p;

  return (_getCurrentInstance = getCurrentInstance('useRouter')) == null ? void 0 : (_getCurrentInstance$p = _getCurrentInstance.proxy) == null ? void 0 : _getCurrentInstance$p.$router;
}
export function useLink(props, attrs) {
  const RouterLink = resolveDynamicComponent('RouterLink');
  const isLink = computed(() => !!(props.href || props.to));
  const isClickable = computed(() => {
    return (isLink == null ? void 0 : isLink.value) || !!(attrs.onClick || attrs.onClickOnce);
  });

  if (typeof RouterLink === 'string') {
    return {
      isLink,
      isClickable,
      href: toRef(props, 'href')
    };
  }

  const link = props.to ? RouterLink.useLink(props) : undefined;
  return { ...link,
    isLink,
    isClickable,
    href: computed(() => props.to ? link == null ? void 0 : link.route.value.href : props.href)
  };
}
export const makeRouterProps = propsFactory({
  href: String,
  replace: Boolean,
  to: [String, Object]
}, 'router');
let inTransition = false;
export function useBackButton(router, cb) {
  let popped = false;
  let removeBefore;
  let removeAfter;

  if (IN_BROWSER) {
    nextTick(() => {
      window.addEventListener('popstate', onPopstate);
      removeBefore = router == null ? void 0 : router.beforeEach((to, from, next) => {
        if (!inTransition) {
          setTimeout(() => popped ? cb(next) : next());
        } else {
          popped ? cb(next) : next();
        }

        inTransition = true;
      });
      removeAfter = router == null ? void 0 : router.afterEach(() => {
        inTransition = false;
      });
    });
    onScopeDispose(() => {
      var _removeBefore, _removeAfter;

      window.removeEventListener('popstate', onPopstate);
      (_removeBefore = removeBefore) == null ? void 0 : _removeBefore();
      (_removeAfter = removeAfter) == null ? void 0 : _removeAfter();
    });
  }

  function onPopstate(e) {
    var _e$state;

    if ((_e$state = e.state) != null && _e$state.replaced) return;
    popped = true;
    setTimeout(() => popped = false);
  }
}
//# sourceMappingURL=router.mjs.map