/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.client;

import java.util.Collection;
import java.util.Map;
import org.whitesource.agent.api.dispatch.AsyncCheckPolicyComplianceRequest;
import org.whitesource.agent.api.dispatch.AsyncCheckPolicyComplianceResponseRequest;
import org.whitesource.agent.api.dispatch.AsyncCheckPolicyComplianceResponseResult;
import org.whitesource.agent.api.dispatch.AsyncCheckPolicyComplianceResult;
import org.whitesource.agent.api.dispatch.AsyncCheckPolicyComplianceStatusRequest;
import org.whitesource.agent.api.dispatch.AsyncCheckPolicyComplianceStatusResult;
import org.whitesource.agent.api.dispatch.CheckPoliciesResult;
import org.whitesource.agent.api.dispatch.CheckPolicyComplianceRequest;
import org.whitesource.agent.api.dispatch.CheckPolicyComplianceResult;
import org.whitesource.agent.api.dispatch.CheckVulnerabilitiesRequest;
import org.whitesource.agent.api.dispatch.CheckVulnerabilitiesResult;
import org.whitesource.agent.api.dispatch.ConfigurationRequest;
import org.whitesource.agent.api.dispatch.ConfigurationResult;
import org.whitesource.agent.api.dispatch.GetDependencyDataRequest;
import org.whitesource.agent.api.dispatch.GetDependencyDataResult;
import org.whitesource.agent.api.dispatch.RequestFactory;
import org.whitesource.agent.api.dispatch.SendMetricsRequest;
import org.whitesource.agent.api.dispatch.SendMetricsResult;
import org.whitesource.agent.api.dispatch.SummaryScanRequest;
import org.whitesource.agent.api.dispatch.SummaryScanResult;
import org.whitesource.agent.api.dispatch.UpdateInventoryRequest;
import org.whitesource.agent.api.dispatch.UpdateInventoryResult;
import org.whitesource.agent.api.dispatch.UpdateType;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.client.WssServiceClient;
import org.whitesource.agent.client.WssServiceClientImpl;
import org.whitesource.agent.client.WssServiceException;

public class WhitesourceService {
    private WssServiceClient client;
    private RequestFactory requestFactory;

    public WhitesourceService() {
        this("generic", "1.0", "1.0");
    }

    public WhitesourceService(String agent, String agentVersion, String pluginVersion) {
        this(agent, agentVersion, pluginVersion, null);
    }

    public WhitesourceService(String agent, String agentVersion, String pluginVersion, String serviceUrl) {
        this(agent, agentVersion, pluginVersion, serviceUrl, true);
    }

    public WhitesourceService(String agent, String agentVersion, String pluginVersion, String serviceUrl, boolean setProxy) {
        this(agent, agentVersion, pluginVersion, serviceUrl, setProxy, 60);
    }

    public WhitesourceService(String agent, String agentVersion, String pluginVersion, String serviceUrl, boolean setProxy, int connectionTimeoutMinutes) {
        this(agent, agentVersion, pluginVersion, serviceUrl, setProxy, connectionTimeoutMinutes, false);
    }

    public WhitesourceService(String agent, String agentVersion, String pluginVersion, String serviceUrl, boolean setProxy, int connectionTimeoutMinutes, boolean ignoreCertificateCheck) {
        this.requestFactory = new RequestFactory(agent, agentVersion, pluginVersion);
        String url = serviceUrl;
        if (url == null || url.trim().length() == 0) {
            url = System.getProperty("wss.url", "https://saas.whitesourcesoftware.com/agent");
        }
        if (connectionTimeoutMinutes <= 0) {
            connectionTimeoutMinutes = Integer.parseInt(System.getProperty("wss.connectionTimeoutMinutes", String.valueOf(60)));
        }
        this.client = new WssServiceClientImpl(url, setProxy, connectionTimeoutMinutes, ignoreCertificateCheck);
    }

    public WhitesourceService(String agent, String agentVersion, String serviceUrl, boolean setProxy) {
        this(agent, agentVersion, serviceUrl, setProxy, 60);
    }

    public WhitesourceService(String agent, String agentVersion, String serviceUrl, boolean setProxy, int connectionTimeoutMinutes) {
        this(agent, agentVersion, null, serviceUrl, setProxy, connectionTimeoutMinutes);
    }

    public WhitesourceService cloneWhitesourceService() {
        WssServiceClient client = this.getClient();
        WhitesourceService whitesourceService = new WhitesourceService(this.requestFactory.getAgent(), this.requestFactory.getAgentVersion(), this.requestFactory.getPluginVersion(), client.getServiceUrl(), client.isProxy(), client.getConnectionTimeoutMinutes(), client.getIgnoreCertificateCheck());
        whitesourceService.getClient().setProxy(client.getProxyHost(), client.getProxyPort(), client.getProxyUsername(), client.getProxyPassword());
        return whitesourceService;
    }

    @Deprecated
    public UpdateInventoryResult update(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) throws WssServiceException {
        return this.update(orgToken, null, product, productVersion, projectInfos, userKey);
    }

    @Deprecated
    public UpdateInventoryResult update(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos) throws WssServiceException {
        return this.update(orgToken, null, product, productVersion, projectInfos, null);
    }

    @Deprecated
    public UpdateInventoryResult update(String orgToken, String requesterEmail, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) throws WssServiceException {
        return this.client.updateInventory(this.requestFactory.newUpdateInventoryRequest(orgToken, requesterEmail, product, productVersion, projectInfos, userKey));
    }

    @Deprecated
    public UpdateInventoryResult update(String orgToken, String requesterEmail, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, Map<String, String> extraProperties) throws WssServiceException {
        return this.client.updateInventory(this.requestFactory.newUpdateInventoryRequest(orgToken, requesterEmail, product, productVersion, projectInfos, userKey, extraProperties));
    }

    @Deprecated
    public UpdateInventoryResult update(String orgToken, String requesterEmail, String product, String productVersion, Collection<AgentProjectInfo> projectInfos) throws WssServiceException {
        return this.update(orgToken, requesterEmail, product, productVersion, projectInfos, null);
    }

    @Deprecated
    public UpdateInventoryResult update(String orgToken, String requesterEmail, UpdateType updateType, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) throws WssServiceException {
        return this.client.updateInventory(this.requestFactory.newUpdateInventoryRequest(orgToken, updateType, requesterEmail, product, productVersion, projectInfos, userKey, null));
    }

    @Deprecated
    public UpdateInventoryResult update(String orgToken, String requesterEmail, UpdateType updateType, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String logData) throws WssServiceException {
        return this.client.updateInventory(this.requestFactory.newUpdateInventoryRequest(orgToken, updateType, requesterEmail, product, productVersion, projectInfos, userKey, logData));
    }

    @Deprecated
    public UpdateInventoryResult update(String orgToken, String requesterEmail, UpdateType updateType, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String logData, String scanComment) throws WssServiceException {
        return this.client.updateInventory(this.requestFactory.newUpdateInventoryRequest(orgToken, updateType, requesterEmail, product, productVersion, projectInfos, userKey, logData, scanComment));
    }

    @Deprecated
    public UpdateInventoryResult update(String orgToken, String requesterEmail, UpdateType updateType, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String logData, String scanComment, String productToken, Map<String, String> extraProperties) throws WssServiceException {
        return this.client.updateInventory(this.requestFactory.newUpdateInventoryRequest(orgToken, updateType, requesterEmail, product, productVersion, projectInfos, userKey, logData, scanComment, productToken, extraProperties));
    }

    @Deprecated
    public UpdateInventoryResult update(String orgToken, String requesterEmail, UpdateType updateType, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String logData, String scanComment, String productToken) throws WssServiceException {
        return this.update(orgToken, requesterEmail, updateType, product, productVersion, projectInfos, userKey, logData, scanComment, productToken, null);
    }

    @Deprecated
    public UpdateInventoryResult update(String orgToken, String requesterEmail, UpdateType updateType, String product, String productVersion, Collection<AgentProjectInfo> projectInfos) throws WssServiceException {
        return this.update(orgToken, requesterEmail, updateType, product, productVersion, projectInfos, null);
    }

    @Deprecated
    public UpdateInventoryResult update(String orgToken, String requesterEmail, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, boolean aggregateModules, boolean preserveModuleStructure, String aggregateProjectName, String aggregateProjectToken) throws WssServiceException {
        return this.client.updateInventory(this.requestFactory.newUpdateInventoryRequest(orgToken, requesterEmail, product, productVersion, projectInfos, userKey, Boolean.valueOf(aggregateModules), Boolean.valueOf(preserveModuleStructure), aggregateProjectName, aggregateProjectToken));
    }

    public UpdateInventoryResult update(UpdateInventoryRequest request) throws WssServiceException {
        return this.client.updateInventory(this.requestFactory.newUpdateInventoryRequest(request));
    }

    @Deprecated
    public UpdateInventoryRequest offlineUpdate(String orgToken, String product, Boolean removeBeforeAdd, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail, String scanComment, String productToken) {
        return this.requestFactory.newUpdateInventoryRequest(orgToken, requesterEmail, product, productVersion, projectInfos, userKey, scanComment, productToken);
    }

    @Deprecated
    public UpdateInventoryRequest offlineUpdate(String orgToken, String product, Boolean removeBeforeAdd, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail, String scanComment) {
        return this.offlineUpdate(orgToken, product, removeBeforeAdd, productVersion, projectInfos, userKey, requesterEmail, scanComment, null);
    }

    @Deprecated
    public UpdateInventoryRequest offlineUpdate(String orgToken, String product, Boolean removeBeforeAdd, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) {
        return this.offlineUpdate(orgToken, product, removeBeforeAdd, productVersion, projectInfos, userKey, null, null);
    }

    @Deprecated
    public UpdateInventoryRequest offlineUpdate(String orgToken, String product, Boolean removeBeforeAdd, String productVersion, Collection<AgentProjectInfo> projectInfos) {
        return this.offlineUpdate(orgToken, product, removeBeforeAdd, productVersion, projectInfos, null);
    }

    @Deprecated
    public UpdateInventoryRequest offlineUpdate(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) {
        return this.offlineUpdate(orgToken, product, false, productVersion, projectInfos, null, null, null);
    }

    @Deprecated
    public UpdateInventoryRequest offlineUpdate(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String scanComment) {
        return this.offlineUpdate(orgToken, product, false, productVersion, projectInfos, null, null, scanComment);
    }

    @Deprecated
    public UpdateInventoryRequest offlineUpdate(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos) {
        return this.offlineUpdate(orgToken, product, productVersion, projectInfos, null);
    }

    public UpdateInventoryRequest offlineUpdate(UpdateInventoryRequest request) {
        return this.requestFactory.newUpdateInventoryRequest(request);
    }

    @Deprecated
    public CheckPoliciesResult checkPolicies(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail) throws WssServiceException {
        return this.client.checkPolicies(this.requestFactory.newCheckPoliciesRequest(orgToken, product, productVersion, projectInfos, userKey, requesterEmail));
    }

    @Deprecated
    public CheckPoliciesResult checkPolicies(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) throws WssServiceException {
        return this.checkPolicies(orgToken, product, productVersion, projectInfos, userKey, null);
    }

    @Deprecated
    public CheckPolicyComplianceResult checkPolicyCompliance(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, boolean forceCheckAllDependencies, String userKey, String requesterEmail, String logData, String productToken) throws WssServiceException {
        return this.client.checkPolicyCompliance(this.requestFactory.newCheckPolicyComplianceRequest(orgToken, product, productVersion, projectInfos, forceCheckAllDependencies, userKey, requesterEmail, logData, productToken));
    }

    @Deprecated
    public CheckPolicyComplianceResult checkPolicyCompliance(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, boolean forceCheckAllDependencies, String userKey, String requesterEmail, String logData) throws WssServiceException {
        return this.checkPolicyCompliance(orgToken, product, productVersion, projectInfos, forceCheckAllDependencies, userKey, requesterEmail, logData, null);
    }

    @Deprecated
    public CheckPolicyComplianceResult checkPolicyCompliance(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, boolean forceCheckAllDependencies, String userKey, String requesterEmail) throws WssServiceException {
        return this.checkPolicyCompliance(orgToken, product, productVersion, projectInfos, forceCheckAllDependencies, userKey, requesterEmail, null);
    }

    @Deprecated
    public CheckPolicyComplianceResult checkPolicyCompliance(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, boolean forceCheckAllDependencies, String userKey) throws WssServiceException {
        return this.checkPolicyCompliance(orgToken, product, productVersion, projectInfos, forceCheckAllDependencies, userKey, null);
    }

    @Deprecated
    public CheckPolicyComplianceResult checkPolicyCompliance(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, boolean forceCheckAllDependencies) throws WssServiceException {
        return this.checkPolicyCompliance(orgToken, product, productVersion, projectInfos, forceCheckAllDependencies, null);
    }

    @Deprecated
    public CheckPolicyComplianceResult checkPolicyCompliance(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, boolean forceCheckAllDependencies, String userKey, String requesterEmail, Boolean aggregateModules, Boolean preserveModuleStructure, String aggregateProjectName, String aggregateProjectToken) throws WssServiceException {
        return this.client.checkPolicyCompliance(this.requestFactory.newCheckPolicyComplianceRequest(orgToken, product, productVersion, projectInfos, forceCheckAllDependencies, userKey, requesterEmail, aggregateModules.booleanValue(), preserveModuleStructure.booleanValue(), aggregateProjectName, aggregateProjectToken));
    }

    public CheckPolicyComplianceResult checkPolicyCompliance(CheckPolicyComplianceRequest request) throws WssServiceException {
        return this.client.checkPolicyCompliance(this.requestFactory.newCheckPolicyComplianceRequest(request));
    }

    public AsyncCheckPolicyComplianceResult asyncCheckPolicyCompliance(AsyncCheckPolicyComplianceRequest request) throws WssServiceException {
        return this.client.asyncCheckPolicyCompliance(this.requestFactory.newAsyncCheckPolicyComplianceRequest(request));
    }

    public AsyncCheckPolicyComplianceStatusResult asyncCheckPolicyComplianceStatus(AsyncCheckPolicyComplianceStatusRequest request) throws WssServiceException {
        return this.client.asyncCheckPolicyComplianceStatus(this.requestFactory.newAsyncCheckPolicyComplianceStatusRequest(request));
    }

    public AsyncCheckPolicyComplianceResponseResult asyncCheckPolicyRComplianceResponse(AsyncCheckPolicyComplianceResponseRequest request) throws WssServiceException {
        return this.client.asyncCheckPolicyComplianceResponse(this.requestFactory.newAsyncCheckPolicyComplianceResponseRequest(request));
    }

    @Deprecated
    public GetDependencyDataResult getDependencyData(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail, String productToken) throws WssServiceException {
        return this.client.getDependencyData(this.requestFactory.newDependencyDataRequest(orgToken, product, productVersion, projectInfos, userKey, requesterEmail, productToken));
    }

    @Deprecated
    public GetDependencyDataResult getDependencyData(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail) throws WssServiceException {
        return this.getDependencyData(orgToken, product, productVersion, projectInfos, userKey, requesterEmail, null);
    }

    @Deprecated
    public GetDependencyDataResult getDependencyData(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) throws WssServiceException {
        return this.getDependencyData(orgToken, product, productVersion, projectInfos, userKey, null);
    }

    @Deprecated
    public GetDependencyDataResult getDependencyData(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos) throws WssServiceException {
        return this.getDependencyData(orgToken, product, productVersion, projectInfos, null);
    }

    public GetDependencyDataResult getDependencyData(GetDependencyDataRequest request) throws WssServiceException {
        return this.client.getDependencyData(this.requestFactory.newDependencyDataRequest(request));
    }

    @Deprecated
    public SummaryScanResult summaryScan(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail, String productToken) throws WssServiceException {
        return this.client.summaryScan(this.requestFactory.newSummaryScanRequest(orgToken, product, productVersion, projectInfos, userKey, requesterEmail, productToken));
    }

    @Deprecated
    public SummaryScanResult summaryScan(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail) throws WssServiceException {
        return this.summaryScan(orgToken, product, productVersion, projectInfos, userKey, requesterEmail, null);
    }

    @Deprecated
    public SummaryScanResult summaryScan(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) throws WssServiceException {
        return this.summaryScan(orgToken, product, productVersion, projectInfos, userKey, null);
    }

    @Deprecated
    public SummaryScanResult summaryScan(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos) throws WssServiceException {
        return this.summaryScan(orgToken, product, productVersion, projectInfos, null);
    }

    public SummaryScanResult summaryScan(SummaryScanRequest request) throws WssServiceException {
        return this.client.summaryScan(this.requestFactory.newSummaryScanRequest(request));
    }

    @Deprecated
    public CheckVulnerabilitiesResult checkVulnerabilities(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail, String productToken) throws WssServiceException {
        return this.client.checkVulnerabilities(this.requestFactory.newCheckVulnerabilitiesRequest(orgToken, product, productVersion, projectInfos, userKey, requesterEmail, productToken));
    }

    @Deprecated
    public CheckVulnerabilitiesResult checkVulnerabilities(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey, String requesterEmail) throws WssServiceException {
        return this.checkVulnerabilities(orgToken, product, productVersion, projectInfos, userKey, requesterEmail, null);
    }

    @Deprecated
    public CheckVulnerabilitiesResult checkVulnerabilities(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos, String userKey) throws WssServiceException {
        return this.checkVulnerabilities(orgToken, product, productVersion, projectInfos, userKey, null);
    }

    @Deprecated
    public CheckVulnerabilitiesResult checkVulnerabilities(String orgToken, String product, String productVersion, Collection<AgentProjectInfo> projectInfos) throws WssServiceException {
        return this.checkVulnerabilities(orgToken, product, productVersion, projectInfos, null);
    }

    public CheckVulnerabilitiesResult checkVulnerabilities(CheckVulnerabilitiesRequest request) throws WssServiceException {
        return this.client.checkVulnerabilities(this.requestFactory.newCheckVulnerabilitiesRequest(request));
    }

    @Deprecated
    public ConfigurationResult getConfiguration(String orgToken, String product, String productVersion, String userKey, String requesterEmail, String productToken) throws WssServiceException {
        return this.client.getConfiguration(this.requestFactory.newConfigurationRequest(orgToken, product, productVersion, userKey, requesterEmail, productToken));
    }

    @Deprecated
    public ConfigurationResult getConfiguration(String orgToken, String product, String productVersion, String userKey, String requesterEmail) throws WssServiceException {
        return this.getConfiguration(orgToken, product, productVersion, userKey, requesterEmail, null);
    }

    @Deprecated
    public ConfigurationResult getConfiguration(String orgToken, String product, String productVersion, String userKey) throws WssServiceException {
        return this.client.getConfiguration(this.requestFactory.newConfigurationRequest(orgToken, product, productVersion, userKey));
    }

    @Deprecated
    public ConfigurationResult getConfiguration(String orgToken, String product, String productVersion) throws WssServiceException {
        return this.getConfiguration(orgToken, product, productVersion, null);
    }

    public ConfigurationResult getConfiguration(ConfigurationRequest request) throws WssServiceException {
        return this.client.getConfiguration(this.requestFactory.newConfigurationRequest(request));
    }

    public SendMetricsResult sendMetrics(SendMetricsRequest request) throws WssServiceException {
        return this.client.sendMetrics(this.requestFactory.newSendMetricsRequest(request));
    }

    public void shutdown() {
        this.client.shutdown();
    }

    public WssServiceClient getClient() {
        return this.client;
    }

    public void setClient(WssServiceClient client) {
        this.client = client;
    }

    public RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public void setRequestFactory(RequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    public void setHeaders(Map<String, String> headers) {
        if (this.client != null) {
            this.client.setHeaders(headers);
        }
    }
}

