/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.client;

import com.github.markusbernhardt.proxy.ProxySearch;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.whitesource.agent.api.dispatch.AsyncCheckPolicyComplianceRequest;
import org.whitesource.agent.api.dispatch.AsyncCheckPolicyComplianceResponseRequest;
import org.whitesource.agent.api.dispatch.AsyncCheckPolicyComplianceResponseResult;
import org.whitesource.agent.api.dispatch.AsyncCheckPolicyComplianceResult;
import org.whitesource.agent.api.dispatch.AsyncCheckPolicyComplianceStatusRequest;
import org.whitesource.agent.api.dispatch.AsyncCheckPolicyComplianceStatusResult;
import org.whitesource.agent.api.dispatch.BaseRequest;
import org.whitesource.agent.api.dispatch.CheckPoliciesRequest;
import org.whitesource.agent.api.dispatch.CheckPoliciesResult;
import org.whitesource.agent.api.dispatch.CheckPolicyComplianceRequest;
import org.whitesource.agent.api.dispatch.CheckPolicyComplianceResult;
import org.whitesource.agent.api.dispatch.CheckVulnerabilitiesRequest;
import org.whitesource.agent.api.dispatch.CheckVulnerabilitiesResult;
import org.whitesource.agent.api.dispatch.ConfigurationRequest;
import org.whitesource.agent.api.dispatch.ConfigurationResult;
import org.whitesource.agent.api.dispatch.GetCloudNativeVulnerabilitiesRequest;
import org.whitesource.agent.api.dispatch.GetCloudNativeVulnerabilitiesResult;
import org.whitesource.agent.api.dispatch.GetDependencyDataRequest;
import org.whitesource.agent.api.dispatch.GetDependencyDataResult;
import org.whitesource.agent.api.dispatch.JwtAccessTokenRequest;
import org.whitesource.agent.api.dispatch.JwtAccessTokenResult;
import org.whitesource.agent.api.dispatch.RequestType;
import org.whitesource.agent.api.dispatch.ResultEnvelope;
import org.whitesource.agent.api.dispatch.SendMetricsRequest;
import org.whitesource.agent.api.dispatch.SendMetricsResult;
import org.whitesource.agent.api.dispatch.ServiceRequest;
import org.whitesource.agent.api.dispatch.SummaryScanRequest;
import org.whitesource.agent.api.dispatch.SummaryScanResult;
import org.whitesource.agent.api.dispatch.UpdateInventoryRequest;
import org.whitesource.agent.api.dispatch.UpdateInventoryResult;
import org.whitesource.agent.client.WssSSLSocketFactory;
import org.whitesource.agent.client.WssServiceClient;
import org.whitesource.agent.client.WssServiceException;
import org.whitesource.agent.utils.ZipUtils;

public class WssServiceClientImpl
implements WssServiceClient {
    private static final String HTTP_PROXY_USER = "http.proxyUser";
    private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    public static final String PROXY_HOST = "proxy.host";
    public static final String PROXY_PORT = "proxy.port";
    public static final String PROXY_USER = "proxy.user";
    public static final String PROXY_PASS = "proxy.pass";
    private static final int TO_MILLISECONDS = 60000;
    private static final String UTF_8 = "UTF-8";
    private static final Log logger = LogFactory.getLog(WssServiceClientImpl.class);
    private static final String TLS = "TLS";
    public static final String SOME_PASSWORD = "some password";
    protected String serviceUrl;
    protected CloseableHttpClient httpClient;
    protected Gson gson;
    protected int connectionTimeout;
    boolean ignoreCertificateCheck;
    private String proxyHost;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private Map<String, String> headers;
    private final boolean proxyEnabled;

    public WssServiceClientImpl() {
        this("https://saas.whitesourcesoftware.com/agent");
    }

    public WssServiceClientImpl(String serviceUrl) {
        this(serviceUrl, true);
    }

    public WssServiceClientImpl(String serviceUrl, boolean setProxy) {
        this(serviceUrl, setProxy, 60);
    }

    public WssServiceClientImpl(String serviceUrl, boolean setProxy, int connectionTimeoutMinutes) {
        this(serviceUrl, setProxy, connectionTimeoutMinutes, false);
    }

    public WssServiceClientImpl(String serviceUrl, boolean setProxy, int connectionTimeoutMinutes, boolean ignoreCertificateCheck) {
        this.proxyEnabled = setProxy;
        this.gson = new Gson();
        this.serviceUrl = serviceUrl == null || serviceUrl.length() == 0 ? "https://saas.whitesourcesoftware.com/agent" : serviceUrl;
        this.connectionTimeout = connectionTimeoutMinutes <= 0 ? 3600000 : connectionTimeoutMinutes * 60000;
        BasicHttpParams params = new BasicHttpParams();
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)true);
        this.httpClient = new DefaultHttpClient();
        if (ignoreCertificateCheck) {
            try {
                logger.warn((Object)"Security Warning - Trusting all certificates");
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                char[] password = SOME_PASSWORD.toCharArray();
                keystore.load(null, password);
                WssSSLSocketFactory sf = new WssSSLSocketFactory(keystore);
                sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
                HttpProtocolParams.setContentCharset((HttpParams)params, (String)UTF_8);
                SchemeRegistry registry = new SchemeRegistry();
                registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
                registry.register(new Scheme("https", (SocketFactory)sf, 443));
                ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, registry);
                this.httpClient = new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        this.setConnectionTimeout(this.connectionTimeout);
        if (this.proxyEnabled) {
            this.findDefaultProxy();
        }
    }

    @Override
    public UpdateInventoryResult updateInventory(UpdateInventoryRequest request) throws WssServiceException {
        return (UpdateInventoryResult)this.service((ServiceRequest)request);
    }

    @Override
    public CheckPoliciesResult checkPolicies(CheckPoliciesRequest request) throws WssServiceException {
        return (CheckPoliciesResult)this.service((ServiceRequest)request);
    }

    @Override
    public CheckPolicyComplianceResult checkPolicyCompliance(CheckPolicyComplianceRequest request) throws WssServiceException {
        return (CheckPolicyComplianceResult)this.service((ServiceRequest)request);
    }

    @Override
    public AsyncCheckPolicyComplianceResult asyncCheckPolicyCompliance(AsyncCheckPolicyComplianceRequest request) throws WssServiceException {
        return (AsyncCheckPolicyComplianceResult)this.service((ServiceRequest)request);
    }

    @Override
    public AsyncCheckPolicyComplianceStatusResult asyncCheckPolicyComplianceStatus(AsyncCheckPolicyComplianceStatusRequest request) throws WssServiceException {
        return (AsyncCheckPolicyComplianceStatusResult)this.service((ServiceRequest)request);
    }

    @Override
    public AsyncCheckPolicyComplianceResponseResult asyncCheckPolicyComplianceResponse(AsyncCheckPolicyComplianceResponseRequest request) throws WssServiceException {
        return (AsyncCheckPolicyComplianceResponseResult)this.service((ServiceRequest)request);
    }

    @Override
    public GetDependencyDataResult getDependencyData(GetDependencyDataRequest request) throws WssServiceException {
        return (GetDependencyDataResult)this.service((ServiceRequest)request);
    }

    @Override
    public SummaryScanResult summaryScan(SummaryScanRequest request) throws WssServiceException {
        return (SummaryScanResult)this.service((ServiceRequest)request);
    }

    @Override
    public CheckVulnerabilitiesResult checkVulnerabilities(CheckVulnerabilitiesRequest request) throws WssServiceException {
        return (CheckVulnerabilitiesResult)this.service((ServiceRequest)request);
    }

    @Override
    public ConfigurationResult getConfiguration(ConfigurationRequest request) throws WssServiceException {
        return (ConfigurationResult)this.service((ServiceRequest)request);
    }

    @Override
    public JwtAccessTokenResult jwtAccessToken(JwtAccessTokenRequest request) throws WssServiceException {
        return (JwtAccessTokenResult)this.service((ServiceRequest)request);
    }

    @Override
    public SendMetricsResult sendMetrics(SendMetricsRequest request) throws WssServiceException {
        return (SendMetricsResult)this.service((ServiceRequest)request);
    }

    @Override
    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    @Override
    public void setProxy(String host, int port, String username, String password) {
        this.proxyHost = host;
        this.proxyPort = port;
        this.proxyUsername = username;
        this.proxyPassword = password;
        if (host == null || host.trim().length() == 0) {
            return;
        }
        if (port < 0 || port > 65535) {
            return;
        }
        HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort);
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
        this.httpClient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
        logger.info((Object)("Using proxy: " + proxy.toHostString()));
        if (this.proxyUsername != null && this.proxyUsername.trim().length() > 0) {
            UsernamePasswordCredentials credentials;
            logger.info((Object)("Proxy username: " + this.proxyUsername));
            if (this.proxyUsername.indexOf(47) >= 0) {
                credentials = new NTCredentials(this.proxyUsername + ":" + this.proxyPassword);
            } else if (this.proxyUsername.indexOf(92) >= 0) {
                this.proxyUsername = this.proxyUsername.replace('\\', '/');
                credentials = new NTCredentials(this.proxyUsername + ":" + this.proxyPassword);
            } else {
                credentials = new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword);
            }
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            this.httpClient = HttpClientBuilder.create().setProxy(proxy).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        }
    }

    @Override
    public void setConnectionTimeout(int timeout) {
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpClient.getParams(), (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)this.httpClient.getParams(), (int)timeout);
    }

    public Map<String, String> findDefaultProxyDetails(String url) {
        HashMap<String, String> proxyDetails = new HashMap<String, String>();
        ProxySearch proxySearch = new ProxySearch();
        proxySearch.addStrategy(ProxySearch.Strategy.JAVA);
        proxySearch.addStrategy(ProxySearch.Strategy.ENV_VAR);
        proxySearch.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
        proxySearch.addStrategy(ProxySearch.Strategy.BROWSER);
        ProxySelector proxySelector = proxySearch.getProxySelector();
        if (proxySelector != null) {
            ProxySelector.setDefault(proxySelector);
            try {
                List<Proxy> proxyList = proxySelector.select(new URI(url));
                if (proxyList != null && !proxyList.isEmpty()) {
                    for (Proxy proxy : proxyList) {
                        InetSocketAddress address = (InetSocketAddress)proxy.address();
                        if (address == null) continue;
                        String host = address.getHostName();
                        int port = address.getPort();
                        String username = System.getProperty(HTTP_PROXY_USER);
                        String password = System.getProperty(HTTP_PROXY_PASSWORD);
                        proxyDetails.put(PROXY_HOST, host);
                        proxyDetails.put(PROXY_PORT, String.valueOf(port));
                        proxyDetails.put(PROXY_USER, username);
                        proxyDetails.put(PROXY_PASS, password);
                    }
                }
            }
            catch (URISyntaxException e) {
                logger.error((Object)("Bad service url: " + this.serviceUrl), (Throwable)e);
            }
        }
        return proxyDetails;
    }

    protected <R> R service(ServiceRequest<R> request) throws WssServiceException {
        Object result;
        String response = "";
        try {
            HttpRequestBase httpRequest = this.createHttpRequest(request);
            RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard").build();
            httpRequest.setConfig(requestConfig);
            logger.trace((Object)("Calling White Source service: " + request));
            response = (String)this.httpClient.execute((HttpUriRequest)httpRequest, (ResponseHandler)new BasicResponseHandler());
            String data = this.extractResultData(response);
            logger.trace((Object)("Result data is: " + data));
            switch (request.type()) {
                case UPDATE: {
                    result = this.gson.fromJson(data, UpdateInventoryResult.class);
                    break;
                }
                case CHECK_POLICIES: {
                    result = this.gson.fromJson(data, CheckPoliciesResult.class);
                    break;
                }
                case CHECK_POLICY_COMPLIANCE: {
                    result = this.gson.fromJson(data, CheckPolicyComplianceResult.class);
                    break;
                }
                case ASYNC_CHECK_POLICY_COMPLIANCE: {
                    result = this.gson.fromJson(data, AsyncCheckPolicyComplianceResult.class);
                    break;
                }
                case ASYNC_CHECK_POLICY_COMPLIANCE_STATUS: {
                    result = this.gson.fromJson(data, AsyncCheckPolicyComplianceStatusResult.class);
                    break;
                }
                case ASYNC_CHECK_POLICY_COMPLIANCE_RESPONSE: {
                    result = this.gson.fromJson(data, AsyncCheckPolicyComplianceResponseResult.class);
                    break;
                }
                case CHECK_VULNERABILITIES: {
                    result = this.gson.fromJson(data, CheckVulnerabilitiesResult.class);
                    break;
                }
                case GET_CLOUD_NATIVE_VULNERABILITIES: {
                    result = this.gson.fromJson(data, GetCloudNativeVulnerabilitiesResult.class);
                    break;
                }
                case GET_DEPENDENCY_DATA: {
                    result = this.gson.fromJson(data, GetDependencyDataResult.class);
                    break;
                }
                case SUMMARY_SCAN: {
                    result = this.gson.fromJson(data, SummaryScanResult.class);
                    break;
                }
                case GET_CONFIGURATION: {
                    result = this.gson.fromJson(data, ConfigurationResult.class);
                    break;
                }
                case JWT_ACCESS_TOKEN: {
                    result = this.gson.fromJson(data, JwtAccessTokenResult.class);
                    break;
                }
                case SEND_METRICS: {
                    result = this.gson.fromJson(data, SendMetricsResult.class);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported request type.");
                }
            }
        }
        catch (JsonSyntaxException e) {
            throw new WssServiceException("JsonSyntax exception. Response data is:  " + response + e.getMessage(), e);
        }
        catch (HttpResponseException e) {
            throw new WssServiceException("Unexpected error. Response data is: " + response + e.getMessage() + " Error code is " + e.getStatusCode(), e.getCause(), e.getStatusCode());
        }
        catch (IOException e) {
            throw new WssServiceException("Unexpected error. Response data is: " + response + e.getMessage(), e);
        }
        return (R)result;
    }

    protected <R> HttpRequestBase createHttpRequest(ServiceRequest<R> request) throws IOException, WssServiceException {
        HttpPost httpRequest = new HttpPost(this.serviceUrl);
        httpRequest.setHeader("Accept", "application/json");
        RequestType requestType = request.type();
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        nvps.add((NameValuePair)new BasicNameValuePair("type", requestType.toString()));
        nvps.add((NameValuePair)new BasicNameValuePair("agent", request.agent()));
        nvps.add((NameValuePair)new BasicNameValuePair("agentVersion", request.agentVersion()));
        nvps.add((NameValuePair)new BasicNameValuePair("token", request.orgToken()));
        nvps.add((NameValuePair)new BasicNameValuePair("userKey", request.userKey()));
        nvps.add((NameValuePair)new BasicNameValuePair("requesterEmail", request.requesterEmail()));
        nvps.add((NameValuePair)new BasicNameValuePair("product", request.product()));
        nvps.add((NameValuePair)new BasicNameValuePair("productVersion", request.productVersion()));
        nvps.add((NameValuePair)new BasicNameValuePair("timeStamp", String.valueOf(request.timeStamp())));
        nvps.add((NameValuePair)new BasicNameValuePair("pluginVersion", String.valueOf(request.pluginVersion())));
        nvps.add((NameValuePair)new BasicNameValuePair("aggregateModules", String.valueOf(request.aggregateModules())));
        nvps.add((NameValuePair)new BasicNameValuePair("preserveModuleStructure", String.valueOf(request.preserveModuleStructure())));
        nvps.add((NameValuePair)new BasicNameValuePair("aggregateProjectName", request.aggregateProjectName()));
        nvps.add((NameValuePair)new BasicNameValuePair("aggregateProjectToken", request.aggregateProjectToken()));
        nvps.add((NameValuePair)new BasicNameValuePair("logData", request.logData()));
        nvps.add((NameValuePair)new BasicNameValuePair("scanComment", request.scanComment()));
        nvps.add((NameValuePair)new BasicNameValuePair("productToken", request.productToken()));
        if (request.extraProperties() != null) {
            String strExtraProperties = this.gson.toJson((Object)request.extraProperties());
            nvps.add((NameValuePair)new BasicNameValuePair("extraProperties", strExtraProperties));
        } else {
            nvps.add((NameValuePair)new BasicNameValuePair("extraProperties", "{}"));
        }
        String jsonDiff = null;
        switch (requestType) {
            case UPDATE: {
                UpdateInventoryRequest updateInventoryRequest = (UpdateInventoryRequest)request;
                nvps.add((NameValuePair)new BasicNameValuePair("scanSummaryInfo", this.gson.toJson((Object)updateInventoryRequest.getScanSummaryInfo())));
                nvps.add((NameValuePair)new BasicNameValuePair("updateType", updateInventoryRequest.getUpdateType().toString()));
                nvps.add((NameValuePair)new BasicNameValuePair("contributions", this.gson.toJson((Object)updateInventoryRequest.getContributions())));
                jsonDiff = this.gson.toJson((Object)updateInventoryRequest.getProjects());
                break;
            }
            case CHECK_POLICIES: {
                jsonDiff = this.gson.toJson((Object)((CheckPoliciesRequest)request).getProjects());
                break;
            }
            case CHECK_POLICY_COMPLIANCE: 
            case ASYNC_CHECK_POLICY_COMPLIANCE: {
                jsonDiff = this.handleCheckPolicyReq(nvps, request);
                break;
            }
            case ASYNC_CHECK_POLICY_COMPLIANCE_STATUS: {
                jsonDiff = this.gson.toJson((Object)((AsyncCheckPolicyComplianceStatusRequest)request).getProjects());
                nvps.add((NameValuePair)new BasicNameValuePair("identifier", ((AsyncCheckPolicyComplianceStatusRequest)request).getIdentifier()));
                break;
            }
            case ASYNC_CHECK_POLICY_COMPLIANCE_RESPONSE: {
                jsonDiff = this.gson.toJson((Object)((AsyncCheckPolicyComplianceResponseRequest)request).getProjects());
                nvps.add((NameValuePair)new BasicNameValuePair("identifier", ((AsyncCheckPolicyComplianceResponseRequest)request).getIdentifier()));
                break;
            }
            case CHECK_VULNERABILITIES: {
                jsonDiff = this.gson.toJson((Object)((CheckVulnerabilitiesRequest)request).getProjects());
                break;
            }
            case GET_CLOUD_NATIVE_VULNERABILITIES: {
                jsonDiff = this.gson.toJson((Object)((GetCloudNativeVulnerabilitiesRequest)request).getProjects());
                break;
            }
            case GET_DEPENDENCY_DATA: {
                jsonDiff = this.gson.toJson((Object)((GetDependencyDataRequest)request).getProjects());
                break;
            }
            case SUMMARY_SCAN: {
                SummaryScanRequest summaryScanRequest = (SummaryScanRequest)request;
                jsonDiff = this.gson.toJson((Object)summaryScanRequest.getProjects());
                break;
            }
            case GET_CONFIGURATION: {
                jsonDiff = this.gson.toJson((Object)((ConfigurationRequest)request).getProjects());
                break;
            }
            case JWT_ACCESS_TOKEN: {
                jsonDiff = this.gson.toJson((Object)((JwtAccessTokenRequest)request).getProjects());
                break;
            }
            case SEND_METRICS: {
                jsonDiff = this.gson.toJson((Object)((SendMetricsRequest)request).getProjects());
                break;
            }
        }
        String compressedString = ZipUtils.compressString(jsonDiff);
        nvps.add((NameValuePair)new BasicNameValuePair("diff", compressedString));
        httpRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, UTF_8));
        if (this.headers != null) {
            this.headers.forEach((arg_0, arg_1) -> ((HttpPost)httpRequest).setHeader(arg_0, arg_1));
        }
        return httpRequest;
    }

    private <R> String handleCheckPolicyReq(List<NameValuePair> nvps, ServiceRequest<R> request) {
        BaseRequest br = (BaseRequest)request;
        nvps.add((NameValuePair)new BasicNameValuePair("scanSummaryInfo", this.gson.toJson((Object)br.getScanSummaryInfo())));
        nvps.add((NameValuePair)new BasicNameValuePair("contributions", this.gson.toJson((Object)br.getContributions())));
        if (request.type() != RequestType.ASYNC_CHECK_POLICY_COMPLIANCE) {
            nvps.add((NameValuePair)new BasicNameValuePair("forceCheckAllDependencies", String.valueOf(((CheckPolicyComplianceRequest)br).isForceCheckAllDependencies())));
            nvps.add((NameValuePair)new BasicNameValuePair("populateVulnerabilities", String.valueOf(((CheckPolicyComplianceRequest)br).isPopulateVulnerabilities())));
        } else {
            nvps.add((NameValuePair)new BasicNameValuePair("forceCheckAllDependencies", String.valueOf(((AsyncCheckPolicyComplianceRequest)br).isForceCheckAllDependencies())));
            nvps.add((NameValuePair)new BasicNameValuePair("populateVulnerabilities", String.valueOf(((AsyncCheckPolicyComplianceRequest)br).isPopulateVulnerabilities())));
        }
        return this.gson.toJson((Object)br.getProjects());
    }

    protected String extractResultData(String response) throws IOException, WssServiceException {
        ResultEnvelope envelope = (ResultEnvelope)this.gson.fromJson(response, ResultEnvelope.class);
        if (envelope == null) {
            throw new WssServiceException("Empty response, response data is: " + response);
        }
        String message = envelope.getMessage();
        String data = envelope.getData();
        String requestToken = envelope.getRequestToken();
        if (1 != envelope.getStatus()) {
            throw new WssServiceException(message + ": " + data, requestToken);
        }
        return data;
    }

    private void findDefaultProxy() {
        Map<String, String> proxyDetails = this.findDefaultProxyDetails(this.serviceUrl);
        if (proxyDetails.size() > 0) {
            this.setProxy(proxyDetails.get(PROXY_HOST), Integer.parseInt(proxyDetails.get(PROXY_PORT)), proxyDetails.get(PROXY_USER), proxyDetails.get(PROXY_PASS));
        }
    }

    private ExclusionStrategy getExclusionStrategy() {
        return new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes fieldAttributes) {
                String name = fieldAttributes.getName();
                return name.equals("optional") || name.equals("checksums") || name.equals("deduped");
            }

            public boolean shouldSkipClass(Class<?> aClass) {
                return false;
            }
        };
    }

    @Override
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Override
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public int getConnectionTimeoutMinutes() {
        return this.connectionTimeout / 60000;
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    public int getProxyPort() {
        return this.proxyPort;
    }

    @Override
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Override
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Override
    public boolean isProxy() {
        return this.proxyEnabled;
    }

    @Override
    public boolean getIgnoreCertificateCheck() {
        return this.ignoreCertificateCheck;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    static class CollectionAdapter
    implements JsonSerializer<Collection<?>> {
        CollectionAdapter() {
        }

        public JsonElement serialize(Collection<?> src, Type typeOfSrc, JsonSerializationContext context) {
            if (src == null || src.isEmpty()) {
                return null;
            }
            JsonArray array = new JsonArray();
            for (Object child : src) {
                JsonElement element = context.serialize(child);
                array.add(element);
            }
            return array;
        }
    }
}

