/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.IOException;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.arquillian.container.StandardContainerDescription;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public interface ContainerDescription {
    public String getProductName();

    public String getProductVersion();

    public String getReleaseCodename();

    public String getReleaseVersion();

    default public ModelVersion getModelVersion() {
        return ModelVersion.DEFAULT;
    }

    public static ContainerDescription lookup(ManagementClient client) throws IOException {
        ModelNode op = Operations.createReadResourceOperation((ModelNode)new ModelNode().setEmptyList());
        ModelNode result = client.getControllerClient().execute(op);
        if (Operations.isSuccessfulOutcome((ModelNode)result)) {
            ModelNode model = Operations.readResult((ModelNode)result);
            String productName = model.hasDefined("product-name") ? model.get("product-name").asString() : "WildFly";
            String productVersion = null;
            if (model.hasDefined("product-version")) {
                productVersion = model.get("product-version").asString();
            }
            String releaseCodename = null;
            if (model.hasDefined("release-codename")) {
                releaseCodename = model.get("release-codename").asString();
            }
            String releaseVersion = null;
            if (model.hasDefined("release-version")) {
                releaseVersion = model.get("release-version").asString();
            }
            ModelVersion modelVersion = new ModelVersion(model.get("management-major-version").asInt(0), model.get("management-minor-version").asInt(0), model.get("management-micro-version").asInt(0));
            return new StandardContainerDescription(productName, productVersion, releaseCodename, releaseVersion, modelVersion);
        }
        Logger.getLogger(ContainerDescription.class).errorf("Failed to read the root resource: ", (Object)Operations.getFailureDescription((ModelNode)result));
        return StandardContainerDescription.NULL_DESCRIPTION;
    }

    public static final class ModelVersion {
        static final ModelVersion DEFAULT = new ModelVersion(0, 0, 0);
        private final int major;
        private final int minor;
        private final int micro;

        ModelVersion(int major, int minor, int micro) {
            this.major = major;
            this.minor = minor;
            this.micro = micro;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getMicro() {
            return this.micro;
        }
    }
}

