/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.context.ContainerContext;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.as.arquillian.api.ContainerResource;
import org.jboss.as.arquillian.container.Authentication;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.arquillian.container.SecurityActions;

public class ContainerResourceTestEnricher
implements TestEnricher {
    @Inject
    private Instance<ContainerRegistry> containerRegistry;
    @Inject
    private Instance<ContainerContext> containerContext;
    @Inject
    private Instance<ManagementClient> managementClient;

    public void enrich(Object testCase) {
        for (Field field : SecurityActions.getFieldsWithAnnotation(testCase.getClass(), ContainerResource.class)) {
            Object value = null;
            try {
                Annotation[] qualifiers = this.filterAnnotations(field.getAnnotations());
                value = this.lookup(field.getType(), field.getAnnotation(ContainerResource.class), qualifiers);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not lookup value for field " + field, e);
            }
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set(testCase, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not set value on field " + field + " using " + value);
            }
        }
    }

    public Object[] resolve(Method method) {
        Object[] values = new Object[method.getParameterTypes().length];
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            ContainerResource resource = this.getResourceAnnotation(method.getParameterAnnotations()[i]);
            if (resource == null) continue;
            Annotation[] qualifiers = this.filterAnnotations(method.getParameterAnnotations()[i]);
            values[i] = this.lookup(method.getParameterTypes()[i], resource, qualifiers);
        }
        return values;
    }

    private Object lookup(Class<?> type, ContainerResource resource, Annotation ... qualifiers) {
        Container container;
        List containers = ((ContainerRegistry)this.containerRegistry.get()).getContainers();
        if (resource.value().isEmpty()) {
            if (containers.size() > 1) {
                throw new RuntimeException("@ContainerResource did not specify a server and more than one server exists in the deployment");
            }
            container = (Container)containers.get(0);
        } else {
            container = ((ContainerRegistry)this.containerRegistry.get()).getContainer(resource.value());
            if (container == null) {
                throw new RuntimeException("@ContainerResource specified non existent server " + resource.value());
            }
        }
        try {
            ((ContainerContext)this.containerContext.get()).activate((Object)container.getName());
            if (Context.class.isAssignableFrom(type)) {
                Object object = this.lookupContext(type, resource, qualifiers);
                return object;
            }
            if (ManagementClient.class.isAssignableFrom(type)) {
                Object object = this.managementClient.get();
                return object;
            }
            throw new RuntimeException("@ContainerResource an unknown type " + resource.value());
        }
        finally {
            ((ContainerContext)this.containerContext.get()).deactivate();
        }
    }

    private Object lookupContext(Class<?> type, ContainerResource resource, Annotation ... qualifiers) {
        try {
            Properties env = new Properties();
            env.put("java.naming.factory.initial", "org.wildfly.naming.client.WildFlyInitialContextFactory");
            env.put("java.naming.provider.url", ((ManagementClient)this.managementClient.get()).getRemoteEjbURL().toString());
            env.put("jboss.naming.client.connect.options.org.xnio.Options.SASL_POLICY_NOPLAINTEXT", "false");
            env.put("jboss.naming.client.security.callback.handler.class", Authentication.CallbackHandler.class.getName());
            return new InitialContext(env);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    private ContainerResource getResourceAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != ContainerResource.class) continue;
            return (ContainerResource)annotation;
        }
        return null;
    }

    private Annotation[] filterAnnotations(Annotation[] annotations) {
        if (annotations == null) {
            return new Annotation[0];
        }
        ArrayList<Annotation> filtered = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() == ContainerResource.class) continue;
            filtered.add(annotation);
        }
        return filtered.toArray(new Annotation[0]);
    }

    private static interface ContainerResourceProvider {
        public Object lookup(Class<?> var1, ContainerResource var2, Annotation ... var3);
    }
}

