/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

class ArquillianConfigBuilder {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.arquillian");
    private static final String CLASS_NAME_JUNIT_RUNNER = "org.junit.runner.RunWith";
    private static final String CLASS_NAME_JUNIT5_RUNNER = "org.junit.jupiter.api.extension.ExtendWith";
    private static final String CLASS_NAME_TESTNG_RUNNER = "org.jboss.arquillian.testng.Arquillian";
    private static final AttachmentKey<Set<String>> CLASSES = AttachmentKey.create(Set.class);

    ArquillianConfigBuilder() {
    }

    static Set<String> getClasses(DeploymentUnit depUnit) {
        Set testClasses = (Set)depUnit.getAttachment(CLASSES);
        return testClasses == null || testClasses.isEmpty() ? null : testClasses;
    }

    static String getName(DeploymentUnit depUnit) {
        String depUnitName = depUnit.getName();
        DeploymentUnit parent = depUnit.getParent();
        if (parent != null) {
            depUnitName = parent.getName() + "." + depUnitName;
        }
        return depUnitName;
    }

    static void handleParseAnnotations(DeploymentUnit deploymentUnit) {
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            log.warnf("Cannot find composite annotation index in: %s", (Object)deploymentUnit);
            return;
        }
        if (deploymentUnit.hasAttachment(CLASSES)) {
            return;
        }
        DotName runWithName = DotName.createSimple((String)CLASS_NAME_JUNIT_RUNNER);
        ArrayList runWithList = new ArrayList(compositeIndex.getAnnotations(runWithName));
        DotName extendWith = DotName.createSimple((String)CLASS_NAME_JUNIT5_RUNNER);
        runWithList.addAll(compositeIndex.getAnnotations(extendWith));
        DotName testNGClassName = DotName.createSimple((String)CLASS_NAME_TESTNG_RUNNER);
        Set testNgTests = compositeIndex.getAllKnownSubclasses(testNGClassName);
        HashSet<String> testClasses = new HashSet<String>();
        for (AnnotationInstance instance : runWithList) {
            AnnotationTarget target = instance.target();
            if (!(target instanceof ClassInfo)) continue;
            ClassInfo classInfo = (ClassInfo)target;
            String testClassName = classInfo.name().toString();
            testClasses.add(testClassName);
        }
        for (ClassInfo classInfo : testNgTests) {
            testClasses.add(classInfo.name().toString());
        }
        deploymentUnit.putAttachment(CLASSES, testClasses);
    }
}

