/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.wildfly.common.Assert;
import org.wildfly.common._private.CommonMessages;

public final class Inet {
    public static final Inet4Address INET4_ANY = Inet.getInet4Address(0, 0, 0, 0);
    public static final Inet4Address INET4_LOOPBACK = Inet.getInet4Address(127, 0, 0, 1);
    public static final Inet4Address INET4_BROADCAST = Inet.getInet4Address(255, 255, 255, 255);
    public static final Inet6Address INET6_ANY = Inet.getInet6Address(0, 0, 0, 0, 0, 0, 0, 0);
    public static final Inet6Address INET6_LOOPBACK = Inet.getInet6Address(0, 0, 0, 0, 0, 0, 0, 1);

    private Inet() {
    }

    public static String toOptimalString(InetAddress inetAddress) {
        Assert.checkNotNullParam("inetAddress", inetAddress);
        return inetAddress instanceof Inet6Address ? Inet.toOptimalStringV6(inetAddress.getAddress()) : inetAddress.getHostAddress();
    }

    public static String toOptimalString(byte[] addressBytes) {
        Assert.checkNotNullParam("addressBytes", addressBytes);
        if (addressBytes.length == 4) {
            return (addressBytes[0] & 0xFF) + "." + (addressBytes[1] & 0xFF) + "." + (addressBytes[2] & 0xFF) + "." + (addressBytes[3] & 0xFF);
        }
        if (addressBytes.length == 16) {
            return Inet.toOptimalStringV6(addressBytes);
        }
        throw CommonMessages.msg.invalidAddressBytes(addressBytes.length);
    }

    public static Inet6Address toInet6Address(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            return (Inet6Address)inetAddress;
        }
        assert (inetAddress instanceof Inet4Address);
        byte[] addr = new byte[16];
        addr[11] = -1;
        addr[10] = -1;
        System.arraycopy(inetAddress.getAddress(), 0, addr, 12, 4);
        try {
            return Inet6Address.getByAddress(Inet.getHostNameIfResolved(inetAddress), addr, 0);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String getHostNameIfResolved(InetAddress inetAddress) {
        String hostString = new InetSocketAddress(inetAddress, 0).getHostString();
        String toString = inetAddress.toString();
        int slash = toString.lastIndexOf(47);
        if (slash == 0) {
            return hostString.isEmpty() ? "" : null;
        }
        return hostString;
    }

    public static Inet4Address getInet4Address(int s1, int s2, int s3, int s4) {
        byte[] bytes = new byte[4];
        Assert.checkMinimumParameter("s1", 0, s1);
        Assert.checkMaximumParameter("s1", 255, s1);
        Assert.checkMinimumParameter("s2", 0, s2);
        Assert.checkMaximumParameter("s2", 255, s2);
        Assert.checkMinimumParameter("s3", 0, s3);
        Assert.checkMaximumParameter("s3", 255, s3);
        Assert.checkMinimumParameter("s4", 0, s4);
        Assert.checkMaximumParameter("s4", 255, s4);
        bytes[0] = (byte)s1;
        bytes[1] = (byte)s2;
        bytes[2] = (byte)s3;
        bytes[3] = (byte)s4;
        try {
            return (Inet4Address)InetAddress.getByAddress(s1 + "." + s2 + "." + s3 + "." + s4, bytes);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Inet6Address getInet6Address(int s1, int s2, int s3, int s4, int s5, int s6, int s7, int s8) {
        byte[] bytes = new byte[16];
        Assert.checkMinimumParameter("s1", 0, s1);
        Assert.checkMaximumParameter("s1", 65535, s1);
        Assert.checkMinimumParameter("s2", 0, s2);
        Assert.checkMaximumParameter("s2", 65535, s2);
        Assert.checkMinimumParameter("s3", 0, s3);
        Assert.checkMaximumParameter("s3", 65535, s3);
        Assert.checkMinimumParameter("s4", 0, s4);
        Assert.checkMaximumParameter("s4", 65535, s4);
        Assert.checkMinimumParameter("s5", 0, s5);
        Assert.checkMaximumParameter("s5", 65535, s5);
        Assert.checkMinimumParameter("s6", 0, s6);
        Assert.checkMaximumParameter("s6", 65535, s6);
        Assert.checkMinimumParameter("s7", 0, s7);
        Assert.checkMaximumParameter("s7", 65535, s7);
        Assert.checkMinimumParameter("s8", 0, s8);
        Assert.checkMaximumParameter("s8", 65535, s8);
        bytes[0] = (byte)(s1 >> 8);
        bytes[1] = (byte)s1;
        bytes[2] = (byte)(s2 >> 8);
        bytes[3] = (byte)s2;
        bytes[4] = (byte)(s3 >> 8);
        bytes[5] = (byte)s3;
        bytes[6] = (byte)(s4 >> 8);
        bytes[7] = (byte)s4;
        bytes[8] = (byte)(s5 >> 8);
        bytes[9] = (byte)s5;
        bytes[10] = (byte)(s6 >> 8);
        bytes[11] = (byte)s6;
        bytes[12] = (byte)(s7 >> 8);
        bytes[13] = (byte)s7;
        bytes[14] = (byte)(s8 >> 8);
        bytes[15] = (byte)s8;
        try {
            return Inet6Address.getByAddress(Inet.toOptimalStringV6(bytes), bytes, 0);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isInet6Address(String address) {
        return Inet.parseInet6AddressToBytes(address) != null;
    }

    public static Inet6Address parseInet6Address(String address) {
        byte[] bytes = Inet.parseInet6AddressToBytes(address);
        if (bytes == null) {
            return null;
        }
        try {
            return Inet6Address.getByAddress(address, bytes, 0);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] parseInet6AddressToBytes(String address) {
        int skippedSegments;
        int skipIndex;
        boolean isDefaultRoute;
        int totalSegments;
        String[] segments;
        if (address == null || address.isEmpty()) {
            return null;
        }
        if (address.startsWith("[") && address.endsWith("]")) {
            address = address.substring(1, address.length() - 1);
        }
        if ((segments = address.split(":", 10)).length > 9 || segments.length < 3) {
            return null;
        }
        if (segments[0].length() == 0 && segments[1].length() != 0) {
            return null;
        }
        if (segments[segments.length - 1].length() == 0 && segments[segments.length - 2].length() != 0) {
            return null;
        }
        for (int i = 0; i < segments.length; ++i) {
            for (int charIdx = 0; charIdx < segments[i].length(); ++charIdx) {
                char c = segments[i].charAt(charIdx);
                if (c == '.' && i != segments.length - 1) {
                    return null;
                }
                if (c == '.' || c == ':' || Character.digit(c, 16) != -1) continue;
                return null;
            }
        }
        int emptyIndex = -1;
        for (int i = 0; i < segments.length - 1; ++i) {
            if (segments[i].length() != 0) continue;
            if (emptyIndex > 0) {
                return null;
            }
            if (emptyIndex == 0) continue;
            emptyIndex = i;
        }
        boolean containsIPv4 = segments[segments.length - 1].contains(".");
        int n = totalSegments = containsIPv4 ? 7 : 8;
        if (emptyIndex == -1 && segments.length != totalSegments) {
            return null;
        }
        boolean bl = isDefaultRoute = segments.length == 3 && segments[0].isEmpty() && segments[1].isEmpty() && segments[2].isEmpty();
        if (isDefaultRoute) {
            skipIndex = 0;
            skippedSegments = 8;
        } else if (segments[0].isEmpty() || segments[segments.length - 1].isEmpty()) {
            skipIndex = emptyIndex;
            skippedSegments = totalSegments - segments.length + 2;
        } else if (emptyIndex > -1) {
            skipIndex = emptyIndex;
            skippedSegments = totalSegments - segments.length + 1;
        } else {
            skipIndex = 0;
            skippedSegments = 0;
        }
        ByteBuffer bytes = ByteBuffer.allocate(16);
        try {
            int i;
            for (i = 0; i < skipIndex; ++i) {
                bytes.putShort(Inet.parseHexadecimal(segments[i]));
            }
            for (i = skipIndex; i < skipIndex + skippedSegments; ++i) {
                bytes.putShort((short)0);
            }
            for (i = skipIndex + skippedSegments; i < totalSegments; ++i) {
                int segmentIdx = segments.length - (totalSegments - i);
                if (containsIPv4 && i == totalSegments - 1) {
                    String[] ipV4Segments = segments[segmentIdx].split("\\.");
                    if (ipV4Segments.length != 4) {
                        return null;
                    }
                    for (int idxV4 = 0; idxV4 < 4; ++idxV4) {
                        bytes.put(Inet.parseDecimal(ipV4Segments[idxV4]));
                    }
                    continue;
                }
                bytes.putShort(Inet.parseHexadecimal(segments[segmentIdx]));
            }
            return bytes.array();
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static byte parseDecimal(String number) {
        int i = Integer.parseInt(number);
        if (i > 255) {
            throw new NumberFormatException();
        }
        return (byte)i;
    }

    private static short parseHexadecimal(String hexNumber) {
        int i = Integer.parseInt(hexNumber, 16);
        if (i > 65535) {
            throw new NumberFormatException();
        }
        return (short)i;
    }

    private static String toOptimalStringV6(byte[] bytes) {
        int[] segments = new int[8];
        for (int i = 0; i < 8; ++i) {
            segments[i] = (bytes[i << 1] & 0xFF) << 8 | bytes[(i << 1) + 1] & 0xFF;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            if (segments[i] == 0) {
                if (i == 7) {
                    b.append('0');
                    continue;
                }
                if (segments[++i] == 0) {
                    b.append(':').append(':');
                    ++i;
                    while (i < 8) {
                        if (segments[i] == 65535 && b.length() == 2) {
                            b.append("ffff");
                            if (i == 5) {
                                b.append(':').append(bytes[12] & 0xFF).append('.').append(bytes[13] & 0xFF).append('.').append(bytes[14] & 0xFF).append('.').append(bytes[15] & 0xFF);
                                i = 8;
                            } else if (i == 4 && segments[5] == 0) {
                                b.append(":0:").append(bytes[12] & 0xFF).append('.').append(bytes[13] & 0xFF).append('.').append(bytes[14] & 0xFF).append('.').append(bytes[15] & 0xFF);
                                i = 8;
                            } else {
                                ++i;
                                while (i < 8) {
                                    b.append(':').append(Integer.toHexString(segments[i]));
                                    ++i;
                                }
                            }
                        } else if (segments[i] != 0) {
                            b.append(Integer.toHexString(segments[i]));
                            ++i;
                            while (i < 8) {
                                b.append(':').append(Integer.toHexString(segments[i]));
                                ++i;
                            }
                        }
                        ++i;
                    }
                    continue;
                }
                if (i > 1) {
                    b.append(':');
                }
                b.append('0').append(':').append(Integer.toHexString(segments[i]));
                continue;
            }
            if (i > 0) {
                b.append(':');
            }
            b.append(Integer.toHexString(segments[i]));
        }
        return b.toString();
    }
}

