/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.datasources;

import java.util.HashMap;
import org.wildfly.extras.creaper.commands.datasources.AddXADataSource;
import org.wildfly.extras.creaper.core.ManagementVersion;

public final class AddMssqlXADataSource
extends AddXADataSource {
    AddMssqlXADataSource(Builder builder) {
        super(builder);
    }

    @Override
    protected void modifyIfNeeded(ManagementVersion serverVersion) {
        if (this.backgroundValidation == null) {
            this.backgroundValidation = true;
        }
        if (this.backgroundValidationMillis == null) {
            this.backgroundValidationMillis = 60000;
        }
        if (this.validConnectionCheckerClass == null) {
            this.validConnectionCheckerClass = "org.jboss.jca.adapters.jdbc.extensions.mssql.MSSQLValidConnectionChecker";
        }
        if (this.exceptionSorterClass == null && serverVersion.greaterThan(ManagementVersion.VERSION_1_7_0)) {
            this.exceptionSorterClass = "org.jboss.jca.adapters.jdbc.extensions.mssql.MSSQLExceptionSorter";
        }
        if (this.sameRmOverride == null) {
            this.sameRmOverride = true;
        }
        if (this.xaDatasourceClass == null) {
            this.xaDatasourceClass = "com.microsoft.sqlserver.jdbc.SQLServerXADataSource";
        }
        if (this.xaDatasourceProperties == null) {
            this.xaDatasourceProperties = new HashMap();
        }
        if (!this.xaDatasourceProperties.containsKey("PortNumber")) {
            this.xaDatasourceProperties.put("PortNumber", "1433");
        }
        if (!this.xaDatasourceProperties.containsKey("SelectMethod")) {
            this.xaDatasourceProperties.put("SelectMethod", "cursor");
        }
    }

    public static final class Builder
    extends AddXADataSource.Builder<Builder> {
        public Builder(String name) {
            super(name);
        }

        @Override
        public AddMssqlXADataSource build() {
            this.check();
            return new AddMssqlXADataSource(this);
        }
    }
}

