/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.datasources;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.extras.creaper.commands.datasources.PoolFlushStrategy;
import org.wildfly.extras.creaper.commands.datasources.TrackStatementType;
import org.wildfly.extras.creaper.commands.datasources.TransactionIsolation;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.ManagementVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public class AddXADataSource
implements OnlineCommand,
OfflineCommand {
    private final String name;
    private final boolean enableAfterCreation;
    private final boolean replaceExisting;
    protected Integer allocationRetry;
    protected Integer allocationRetryWaitMillis;
    protected Boolean allowMultipleUsers;
    protected Boolean backgroundValidation;
    protected Integer backgroundValidationMillis;
    protected Integer blockingTimeoutWaitMillis;
    protected String checkValidConnectionSql;
    protected String driverName;
    protected String exceptionSorterClass;
    protected Map<String, String> exceptionSorterProperties;
    protected PoolFlushStrategy flushStrategy;
    protected Integer idleTimeoutMinutes;
    protected Boolean interleaving;
    protected String jndiName;
    protected String mcp;
    protected Integer maxPoolSize;
    protected Integer minPoolSize;
    protected String newConnectionSql;
    protected Boolean noRecovery;
    protected Boolean noTxSeparatePool;
    protected Boolean padXid;
    protected String password;
    protected Boolean prefill;
    protected Boolean useStrictMinPoolSize;
    protected Integer preparedStatementsCacheSize;
    protected Integer queryTimeout;
    protected String reauthPluginClass;
    protected Map<String, String> reauthPluginProperties;
    protected String recoveryUsername;
    protected String recoveryPassword;
    protected String recoverySecurityDomain;
    protected String recoveryPluginClass;
    protected Map<String, String> recoveryPluginProperties;
    protected Boolean sameRmOverride;
    protected String securityDomain;
    protected Boolean setTxQueryTimeout;
    protected Boolean sharePreparedStatements;
    protected Boolean spy;
    protected String staleConnectionCheckerClass;
    protected Map<String, String> staleConnectionCheckerProperties;
    protected Boolean statisticsEnabled;
    protected TrackStatementType trackPreparedStatements;
    protected TransactionIsolation transactionIsolation;
    protected String urlDelimiter;
    protected String urlSelectorStrategyClass;
    protected Boolean useCcm;
    protected Boolean useFastFailAllocation;
    protected Boolean useJavaContext;
    protected Integer useTryLock;
    protected String username;
    protected String validConnectionCheckerClass;
    protected Map<String, String> validConnectionCheckerProperties;
    protected Boolean validateOnMatch;
    protected Boolean wrapXaResource;
    protected String xaDatasourceClass;
    protected Integer xaResourceTimeout;
    protected Map<String, String> xaDatasourceProperties;

    protected AddXADataSource(Builder builder) {
        this.name = builder.name;
        this.enableAfterCreation = builder.enableAfterCreation;
        this.replaceExisting = builder.replaceExisting;
        this.allocationRetry = builder.allocationRetry;
        this.allocationRetryWaitMillis = builder.allocationRetryWaitMillis;
        this.allowMultipleUsers = builder.allowMultipleUsers;
        this.backgroundValidation = builder.backgroundValidation;
        this.backgroundValidationMillis = builder.backgroundValidationMillis;
        this.blockingTimeoutWaitMillis = builder.blockingTimeoutWaitMillis;
        this.checkValidConnectionSql = builder.checkValidConnectionSql;
        this.driverName = builder.driverName;
        this.exceptionSorterClass = builder.exceptionSorterClass;
        this.exceptionSorterProperties = builder.exceptionSorterProperties;
        this.flushStrategy = builder.flushStrategy;
        this.idleTimeoutMinutes = builder.idleTimeoutMinutes;
        this.interleaving = builder.interleaving;
        this.jndiName = builder.jndiName;
        this.mcp = builder.mcp;
        this.maxPoolSize = builder.maxPoolSize;
        this.minPoolSize = builder.minPoolSize;
        this.newConnectionSql = builder.newConnectionSql;
        this.noRecovery = builder.noRecovery;
        this.noTxSeparatePool = builder.noTxSeparatePool;
        this.padXid = builder.padXid;
        this.password = builder.password;
        this.prefill = builder.prefill;
        this.useStrictMinPoolSize = builder.useStrictMinPoolSize;
        this.preparedStatementsCacheSize = builder.preparedStatementsCacheSize;
        this.queryTimeout = builder.queryTimeout;
        this.reauthPluginClass = builder.reauthPluginClass;
        this.reauthPluginProperties = builder.reauthPluginProperties;
        this.recoveryUsername = builder.recoveryUsername;
        this.recoveryPassword = builder.recoveryPassword;
        this.recoverySecurityDomain = builder.recoverySecurityDomain;
        this.recoveryPluginClass = builder.recoveryPluginClass;
        this.recoveryPluginProperties = builder.recoveryPluginProperties;
        this.sameRmOverride = builder.sameRmOverride;
        this.securityDomain = builder.securityDomain;
        this.setTxQueryTimeout = builder.setTxQueryTimeout;
        this.sharePreparedStatements = builder.sharePreparedStatements;
        this.spy = builder.spy;
        this.staleConnectionCheckerClass = builder.staleConnectionCheckerClass;
        this.staleConnectionCheckerProperties = builder.staleConnectionCheckerProperties;
        this.statisticsEnabled = builder.statisticsEnabled;
        this.trackPreparedStatements = builder.trackPreparedStatements;
        this.transactionIsolation = builder.transactionIsolation;
        this.urlDelimiter = builder.urlDelimiter;
        this.urlSelectorStrategyClass = builder.urlSelectorStrategyClass;
        this.useCcm = builder.useCcm;
        this.useFastFailAllocation = builder.useFastFailAllocation;
        this.useJavaContext = builder.useJavaContext;
        this.useTryLock = builder.useTryLock;
        this.username = builder.username;
        this.validConnectionCheckerClass = builder.validConnectionCheckerClass;
        this.validConnectionCheckerProperties = builder.validConnectionCheckerProperties;
        this.validateOnMatch = builder.validateOnMatch;
        this.wrapXaResource = builder.wrapXaResource;
        this.xaDatasourceClass = builder.xaDatasourceClass;
        this.xaResourceTimeout = builder.xaResourceTimeout;
        this.xaDatasourceProperties = builder.xaDatasourceProperties;
    }

    public final void apply(OnlineCommandContext ctx) throws IOException, CommandFailedException {
        this.modifyIfNeeded(ctx.serverVersion);
        Operations ops = new Operations(ctx.client);
        Address dsAddress = Address.subsystem((String)"datasources").and("xa-data-source", this.name);
        if (this.replaceExisting) {
            try {
                ops.removeIfExists(dsAddress);
                new Administration(ctx.client).reloadIfRequired();
            }
            catch (Exception e) {
                throw new CommandFailedException("Failed to remove existing XA datasource " + this.name, (Throwable)e);
            }
        }
        Values values = Values.empty().andOptional("allocation-retry", this.allocationRetry).andOptional("allocation-retry-wait-millis", this.allocationRetryWaitMillis).andOptional("allow-multiple-users", this.allowMultipleUsers).andOptional("background-validation", this.backgroundValidation).andOptional("background-validation-millis", this.backgroundValidationMillis).andOptional("blocking-timeout-wait-millis", this.blockingTimeoutWaitMillis).andOptional("check-valid-connection-sql", this.checkValidConnectionSql).andOptional("driver-name", this.driverName).andOptional("exception-sorter-class-name", this.exceptionSorterClass).andObjectOptional("exception-sorter-properties", Values.fromMap(this.exceptionSorterProperties)).andOptional("idle-timeout-minutes", this.idleTimeoutMinutes).andOptional("interleaving", this.interleaving).andOptional("jndi-name", this.jndiName).andOptional("mcp", this.mcp).andOptional("max-pool-size", this.maxPoolSize).andOptional("min-pool-size", this.minPoolSize).andOptional("new-connection-sql", this.newConnectionSql).andOptional("no-recovery", this.noRecovery).andOptional("no-tx-separate-pool", this.noTxSeparatePool).andOptional("pad-xid", this.padXid).andOptional("password", this.password).andOptional("pool-prefill", this.prefill).andOptional("pool-use-strict-min", this.useStrictMinPoolSize).andOptional("prepared-statements-cache-size", this.preparedStatementsCacheSize).andOptional("query-timeout", this.queryTimeout).andOptional("reauth-plugin-class-name", this.reauthPluginClass).andObjectOptional("reauth-plugin-properties", Values.fromMap(this.reauthPluginProperties)).andOptional("recovery-password", this.recoveryPassword).andOptional("recovery-plugin-class-name", this.recoveryPluginClass).andObjectOptional("recovery-plugin-properties", Values.fromMap(this.recoveryPluginProperties)).andOptional("recovery-security-domain", this.recoverySecurityDomain).andOptional("recovery-username", this.recoveryUsername).andOptional("same-rm-override", this.sameRmOverride).andOptional("security-domain", this.securityDomain).andOptional("set-tx-query-timeout", this.setTxQueryTimeout).andOptional("share-prepared-statements", this.sharePreparedStatements).andOptional("spy", this.spy).andOptional("stale-connection-checker-class-name", this.staleConnectionCheckerClass).andObjectOptional("stale-connection-checker-properties", Values.fromMap(this.staleConnectionCheckerProperties)).andOptional("statistics-enabled", this.statisticsEnabled).andOptional("url-delimiter", this.urlDelimiter).andOptional("url-selector-strategy-class-name", this.urlSelectorStrategyClass).andOptional("use-ccm", this.useCcm).andOptional("use-fast-fail", this.useFastFailAllocation).andOptional("use-java-context", this.useJavaContext).andOptional("use-try-lock", this.useTryLock).andOptional("user-name", this.username).andOptional("valid-connection-checker-class-name", this.validConnectionCheckerClass).andObjectOptional("valid-connection-checker-properties", Values.fromMap(this.validConnectionCheckerProperties)).andOptional("validate-on-match", this.validateOnMatch).andOptional("wrap-xa-resource", this.wrapXaResource).andOptional("xa-datasource-class", this.xaDatasourceClass).andOptional("xa-resource-timeout", this.xaResourceTimeout).and("enabled", this.enableAfterCreation);
        if (this.flushStrategy != null) {
            values = values.and("flush-strategy", this.flushStrategy.value());
        }
        if (this.transactionIsolation != null) {
            values = values.and("transaction-isolation", this.transactionIsolation.value());
        }
        if (this.trackPreparedStatements != null) {
            values = values.and("track-statements", this.trackPreparedStatements.value());
        }
        Batch batch = new Batch();
        batch.add(dsAddress, values);
        if (this.xaDatasourceProperties != null) {
            for (Map.Entry<String, String> entry : this.xaDatasourceProperties.entrySet()) {
                batch.add(dsAddress.and("xa-datasource-properties", entry.getKey()), Values.of((String)"value", (String)entry.getValue()));
            }
        }
        if (this.enableAfterCreation && ctx.serverVersion.lessThan(ManagementVersion.VERSION_2_0_0)) {
            batch.invoke("enable", dsAddress);
        }
        ops.batch(batch);
    }

    public final void apply(OfflineCommandContext ctx) throws CommandFailedException {
        this.modifyIfNeeded(ctx.serverVersion);
        GroovyXmlTransform transform = GroovyXmlTransform.of(AddXADataSource.class).subtree("datasources", Subtree.subsystem("datasources")).parameter("poolName", this.name).parameter("enableAfterCreation", this.enableAfterCreation).parameter("replaceExisting", this.replaceExisting).parameter("allocationRetry", this.allocationRetry).parameter("allocationRetryWaitMillis", this.allocationRetryWaitMillis).parameter("allowMultipleUsers", this.allowMultipleUsers).parameter("backgroundValidation", this.backgroundValidation).parameter("backgroundValidationMillis", this.backgroundValidationMillis).parameter("blockingTimeoutWaitMillis", this.blockingTimeoutWaitMillis).parameter("checkValidConnectionSql", this.checkValidConnectionSql).parameter("driverName", this.driverName).parameter("exceptionSorterClass", this.exceptionSorterClass).parameter("exceptionSorterProperties", this.exceptionSorterProperties).parameter("flushStrategy", this.flushStrategy == null ? null : this.flushStrategy.value()).parameter("idleTimeoutMinutes", this.idleTimeoutMinutes).parameter("interleaving", this.interleaving).parameter("jndiName", this.jndiName).parameter("maxPoolSize", this.maxPoolSize).parameter("mcp", this.mcp).parameter("minPoolSize", this.minPoolSize).parameter("newConnectionSql", this.newConnectionSql).parameter("noRecovery", this.noRecovery).parameter("noTxSeparatePool", this.noTxSeparatePool).parameter("padXid", this.padXid).parameter("password", this.password).parameter("prefill", this.prefill).parameter("useStrictMinPoolSize", this.useStrictMinPoolSize).parameter("preparedStatementsCacheSize", this.preparedStatementsCacheSize).parameter("queryTimeout", this.queryTimeout).parameter("reauthPluginClass", this.reauthPluginClass).parameter("reauthPluginProperties", this.reauthPluginProperties).parameter("recoveryUsername", this.recoveryUsername).parameter("recoveryPassword", this.recoveryPassword).parameter("recoverySecurityDomain", this.recoverySecurityDomain).parameter("recoveryPluginClass", this.recoveryPluginClass).parameter("recoveryPluginProperties", this.recoveryPluginProperties).parameter("sameRmOverride", this.sameRmOverride).parameter("securityDomain", this.securityDomain).parameter("setTxQueryTimeout", this.setTxQueryTimeout).parameter("sharePreparedStatements", this.sharePreparedStatements).parameter("spy", this.spy).parameter("staleConnectionCheckerClass", this.staleConnectionCheckerClass).parameter("staleConnectionCheckerProperties", this.staleConnectionCheckerProperties).parameter("statisticsEnabled", this.statisticsEnabled).parameter("trackPreparedStatements", this.trackPreparedStatements == null ? null : this.trackPreparedStatements.value()).parameter("transactionIsolation", this.transactionIsolation == null ? null : this.transactionIsolation.value()).parameter("urlDelimiter", this.urlDelimiter).parameter("urlSelectorStrategyClass", this.urlSelectorStrategyClass).parameter("useCcm", this.useCcm).parameter("useFastFail", this.useFastFailAllocation).parameter("useJavaContext", this.useJavaContext).parameter("useTryLock", this.useTryLock).parameter("username", this.username).parameter("validConnectionCheckerClass", this.validConnectionCheckerClass).parameter("validConnectionCheckerProperties", this.validConnectionCheckerProperties).parameter("validateOnMatch", this.validateOnMatch).parameter("wrapXaResource", this.wrapXaResource).parameter("xaDatasourceClass", this.xaDatasourceClass).parameter("xaResourceTimeout", this.xaResourceTimeout).parameter("xaDatasourceProperties", this.xaDatasourceProperties).build();
        ctx.client.apply(new OfflineCommand[]{transform});
    }

    protected void modifyIfNeeded(ManagementVersion serverVersion) {
    }

    public final String toString() {
        return "AddXADataSource " + this.name;
    }

    public static class Builder<THIS extends Builder> {
        private String name;
        private boolean enableAfterCreation = false;
        private boolean replaceExisting = false;
        private Integer allocationRetry;
        private Integer allocationRetryWaitMillis;
        private Boolean allowMultipleUsers;
        private Boolean backgroundValidation;
        private Integer backgroundValidationMillis;
        private Integer blockingTimeoutWaitMillis;
        private String checkValidConnectionSql;
        private String driverName;
        private String exceptionSorterClass;
        private Map<String, String> exceptionSorterProperties = new HashMap<String, String>();
        private PoolFlushStrategy flushStrategy;
        private Integer idleTimeoutMinutes;
        private Boolean interleaving;
        private String jndiName;
        private Integer maxPoolSize;
        private String mcp;
        private Integer minPoolSize;
        private String newConnectionSql;
        private Boolean noRecovery;
        private Boolean noTxSeparatePool;
        private Boolean padXid;
        private String password;
        private Boolean prefill;
        private Boolean useStrictMinPoolSize;
        private Integer preparedStatementsCacheSize;
        private Integer queryTimeout;
        private String reauthPluginClass;
        private Map<String, String> reauthPluginProperties = new HashMap<String, String>();
        private String recoveryUsername;
        private String recoveryPassword;
        private String recoverySecurityDomain;
        private String recoveryPluginClass;
        private Map<String, String> recoveryPluginProperties = new HashMap<String, String>();
        private Boolean sameRmOverride;
        private String securityDomain;
        private Boolean setTxQueryTimeout;
        private Boolean sharePreparedStatements;
        private Boolean spy;
        private String staleConnectionCheckerClass;
        private Map<String, String> staleConnectionCheckerProperties = new HashMap<String, String>();
        private Boolean statisticsEnabled;
        private TrackStatementType trackPreparedStatements;
        private TransactionIsolation transactionIsolation;
        private String urlDelimiter;
        private String urlSelectorStrategyClass;
        private Boolean useCcm;
        private Boolean useFastFailAllocation;
        private Boolean useJavaContext;
        private Integer useTryLock;
        private String username;
        private String validConnectionCheckerClass;
        private Map<String, String> validConnectionCheckerProperties = new HashMap<String, String>();
        private Boolean validateOnMatch;
        private Boolean wrapXaResource;
        private String xaDatasourceClass;
        private Integer xaResourceTimeout;
        private Map<String, String> xaDatasourceProperties = new HashMap<String, String>();

        public Builder(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Name of the xa-data-source must be specified as non null value");
            }
            this.name = name;
        }

        public final THIS driverName(String driverName) {
            this.driverName = driverName;
            return (THIS)this;
        }

        public final THIS jndiName(String jndiName) {
            this.jndiName = jndiName;
            return (THIS)this;
        }

        public final THIS usernameAndPassword(String username, String password) {
            this.username = username;
            this.password = password;
            return (THIS)this;
        }

        public final THIS enableAfterCreate() {
            this.enableAfterCreation = true;
            return (THIS)this;
        }

        public final THIS replaceExisting() {
            this.replaceExisting = true;
            return (THIS)this;
        }

        public final THIS xaDatasourceClass(String xaDatasourceClass) {
            this.xaDatasourceClass = xaDatasourceClass;
            return (THIS)this;
        }

        public final THIS maxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return (THIS)this;
        }

        public final THIS minPoolSize(int minPoolSize) {
            this.minPoolSize = minPoolSize;
            return (THIS)this;
        }

        public final THIS addXaDatasourceProperty(String name, String value) {
            this.xaDatasourceProperties.put(name, value);
            return (THIS)this;
        }

        public final THIS addXaDatasourceProperty(String name, boolean value) {
            this.xaDatasourceProperties.put(name, Boolean.toString(value));
            return (THIS)this;
        }

        public final THIS addXaDatasourceProperties(Map<String, String> xaDatasourceProperties) {
            this.xaDatasourceProperties.putAll(xaDatasourceProperties);
            return (THIS)this;
        }

        public final THIS allocationRetry(Integer allocationRetry) {
            this.allocationRetry = allocationRetry;
            return (THIS)this;
        }

        public final THIS allowMultipleUsers(Boolean allowMultipleUsers) {
            this.allowMultipleUsers = allowMultipleUsers;
            return (THIS)this;
        }

        public final THIS allocationRetryWaitMillis(Integer allocationRetryWaitMillis) {
            this.allocationRetryWaitMillis = allocationRetryWaitMillis;
            return (THIS)this;
        }

        public final THIS backgroundValidation(Boolean backgroundValidation) {
            this.backgroundValidation = backgroundValidation;
            return (THIS)this;
        }

        public final THIS backgroundValidationMillis(Integer backgroundValidationMillis) {
            this.backgroundValidationMillis = backgroundValidationMillis;
            return (THIS)this;
        }

        public final THIS blockingTimeoutWaitMillis(Integer blockingTimeoutWaitMillis) {
            this.blockingTimeoutWaitMillis = blockingTimeoutWaitMillis;
            return (THIS)this;
        }

        public final THIS checkValidConnectionSql(String checkValidConnectionSql) {
            this.checkValidConnectionSql = checkValidConnectionSql;
            return (THIS)this;
        }

        public final THIS exceptionSorterClass(String exceptionSorterClass) {
            this.exceptionSorterClass = exceptionSorterClass;
            return (THIS)this;
        }

        public final THIS addExceptionSorterProperty(String name, String value) {
            this.exceptionSorterProperties.put(name, value);
            return (THIS)this;
        }

        public final THIS addExceptionSorterProperty(String name, boolean value) {
            this.exceptionSorterProperties.put(name, Boolean.toString(value));
            return (THIS)this;
        }

        public final THIS flushStrategy(PoolFlushStrategy flushStrategy) {
            this.flushStrategy = flushStrategy;
            return (THIS)this;
        }

        public final THIS idleTimeoutMinutes(Integer idleTimeoutMinutes) {
            this.idleTimeoutMinutes = idleTimeoutMinutes;
            return (THIS)this;
        }

        public final THIS interleaving(boolean interleaving) {
            this.interleaving = interleaving;
            return (THIS)this;
        }

        public final THIS managedConnectionPool(String mcp) {
            this.mcp = mcp;
            return (THIS)this;
        }

        public final THIS newConnectionSql(String newConnectionSql) {
            this.newConnectionSql = newConnectionSql;
            return (THIS)this;
        }

        public final THIS noRecovery(Boolean noRecovery) {
            this.noRecovery = noRecovery;
            return (THIS)this;
        }

        public final THIS noTxSeparatePool(Boolean noTxSeparatePool) {
            this.noTxSeparatePool = noTxSeparatePool;
            return (THIS)this;
        }

        public final THIS padXid(Boolean padXid) {
            this.padXid = padXid;
            return (THIS)this;
        }

        public final THIS prefill(Boolean prefill) {
            this.prefill = prefill;
            return (THIS)this;
        }

        public final THIS useStrictMinPoolSize(Boolean useStrictMinPoolSize) {
            this.useStrictMinPoolSize = useStrictMinPoolSize;
            return (THIS)this;
        }

        public final THIS preparedStatementsCacheSize(Integer preparedStatementsCacheSize) {
            this.preparedStatementsCacheSize = preparedStatementsCacheSize;
            return (THIS)this;
        }

        public final THIS queryTimeout(Integer queryTimeout) {
            this.queryTimeout = queryTimeout;
            return (THIS)this;
        }

        public final THIS reauthPluginClass(String reauthPluginClass) {
            this.reauthPluginClass = reauthPluginClass;
            return (THIS)this;
        }

        public final THIS addReauthPluginProperty(String name, String value) {
            this.reauthPluginProperties.put(name, value);
            return (THIS)this;
        }

        public final THIS addReauthPluginProperty(String name, boolean value) {
            this.reauthPluginProperties.put(name, Boolean.toString(value));
            return (THIS)this;
        }

        public final THIS recoveryUsernameAndPassword(String username, String password) {
            this.recoveryUsername = username;
            this.recoveryPassword = password;
            return (THIS)this;
        }

        public final THIS recoveryPluginClass(String recoveryPluginClass) {
            this.recoveryPluginClass = recoveryPluginClass;
            return (THIS)this;
        }

        public final THIS addRecoveryPluginProperty(String name, String value) {
            this.recoveryPluginProperties.put(name, value);
            return (THIS)this;
        }

        public final THIS addRecoveryPluginProperty(String name, boolean value) {
            this.recoveryPluginProperties.put(name, Boolean.toString(value));
            return (THIS)this;
        }

        public final THIS recoverySecurityDomain(String securityDomain) {
            this.recoverySecurityDomain = securityDomain;
            return (THIS)this;
        }

        public final THIS sameRmOverride(Boolean isSameRmOverride) {
            this.sameRmOverride = isSameRmOverride;
            return (THIS)this;
        }

        public final THIS securityDomain(String securityDomain) {
            this.securityDomain = securityDomain;
            return (THIS)this;
        }

        public final THIS setTxQueryTimeout(Boolean setTxQueryTimeout) {
            this.setTxQueryTimeout = setTxQueryTimeout;
            return (THIS)this;
        }

        public final THIS sharePreparedStatements(Boolean sharePreparedStatements) {
            this.sharePreparedStatements = sharePreparedStatements;
            return (THIS)this;
        }

        public final THIS spy(Boolean spy) {
            this.spy = spy;
            return (THIS)this;
        }

        public final THIS staleConnectionCheckerClass(String staleConnectionCheckerClass) {
            this.staleConnectionCheckerClass = staleConnectionCheckerClass;
            return (THIS)this;
        }

        public final THIS addStaleConnectionCheckerProperty(String name, String value) {
            this.staleConnectionCheckerProperties.put(name, value);
            return (THIS)this;
        }

        public final THIS addStaleConnectionCheckerProperty(String name, boolean value) {
            this.staleConnectionCheckerProperties.put(name, Boolean.toString(value));
            return (THIS)this;
        }

        public final THIS statisticsEnabled(Boolean statisticsEnabled) {
            this.statisticsEnabled = statisticsEnabled;
            return (THIS)this;
        }

        public final THIS trackPreparedStatements(TrackStatementType trackPreparedStatements) {
            this.trackPreparedStatements = trackPreparedStatements;
            return (THIS)this;
        }

        public final THIS transactionIsolation(TransactionIsolation transactionIsolation) {
            this.transactionIsolation = transactionIsolation;
            return (THIS)this;
        }

        public final THIS urlDelimiter(String urlDelimiter) {
            this.urlDelimiter = urlDelimiter;
            return (THIS)this;
        }

        public final THIS urlSelectorStrategyClass(String urlSelectorStrategyClass) {
            this.urlSelectorStrategyClass = urlSelectorStrategyClass;
            return (THIS)this;
        }

        public final THIS useCcm(Boolean useCcm) {
            this.useCcm = useCcm;
            return (THIS)this;
        }

        public final THIS useFastFailAllocation(Boolean useFastFailAllocation) {
            this.useFastFailAllocation = useFastFailAllocation;
            return (THIS)this;
        }

        public final THIS useJavaContext(Boolean useJavaContext) {
            this.useJavaContext = useJavaContext;
            return (THIS)this;
        }

        public final THIS useTryLock(Integer useTryLock) {
            this.useTryLock = useTryLock;
            return (THIS)this;
        }

        public final THIS validConnectionCheckerClass(String validConnectionCheckerClass) {
            this.validConnectionCheckerClass = validConnectionCheckerClass;
            return (THIS)this;
        }

        public final THIS addValidConnectionCheckerProperty(String name, String value) {
            this.validConnectionCheckerProperties.put(name, value);
            return (THIS)this;
        }

        public final THIS addValidConnectionCheckerProperty(String name, boolean value) {
            this.validConnectionCheckerProperties.put(name, Boolean.toString(value));
            return (THIS)this;
        }

        public final THIS validateOnMatch(Boolean validateOnMatch) {
            this.validateOnMatch = validateOnMatch;
            return (THIS)this;
        }

        public final THIS wrapXaResource(Boolean wrapXaResource) {
            this.wrapXaResource = wrapXaResource;
            return (THIS)this;
        }

        public final THIS xaResourceTimeout(Integer xaResourceTimeout) {
            this.xaResourceTimeout = xaResourceTimeout;
            return (THIS)this;
        }

        public AddXADataSource build() {
            this.check();
            return new AddXADataSource(this);
        }

        protected final void check() {
            if (this.jndiName == null) {
                throw new IllegalArgumentException("jndiName must be specified as non null value");
            }
            if (this.driverName == null) {
                throw new IllegalArgumentException("driverName must be specified as non null value");
            }
            if (this.minPoolSize != null && this.minPoolSize < 0) {
                throw new IllegalArgumentException("minPoolSize must be greater than 0 but it's set to " + this.minPoolSize);
            }
            if (this.maxPoolSize != null && this.maxPoolSize < 0) {
                throw new IllegalArgumentException("maxPoolSize must be greater than 0 but it's set to " + this.maxPoolSize);
            }
            if (this.maxPoolSize != null && this.minPoolSize != null && this.minPoolSize > this.maxPoolSize) {
                throw new IllegalArgumentException("maxPoolSize has to be greater than minPoolSize but they are set to " + this.minPoolSize + " and " + this.maxPoolSize);
            }
            if (this.backgroundValidationMillis != null && this.backgroundValidationMillis < 0) {
                throw new IllegalArgumentException("backgroundValidationMilis has to be greater than 0 but it's set to " + this.backgroundValidationMillis);
            }
            if (this.queryTimeout != null && this.queryTimeout < 0) {
                throw new IllegalArgumentException("queryTimeout has to be greater than 0 but it's set to " + this.queryTimeout);
            }
            if (this.useTryLock != null && this.useTryLock < 0) {
                throw new IllegalArgumentException("useTryLock has to be greater than 0 but it's set to " + this.useTryLock);
            }
            if (this.allocationRetry != null && this.allocationRetry < 0) {
                throw new IllegalArgumentException("allocationRetry has to be greater than 0 but it's set to " + this.allocationRetry);
            }
            if (this.allocationRetryWaitMillis != null && this.allocationRetryWaitMillis < 0) {
                throw new IllegalArgumentException("allocationRetryWaitMillis has to be greater than 0 but it's set to " + this.allocationRetryWaitMillis);
            }
            if (this.preparedStatementsCacheSize != null && this.preparedStatementsCacheSize < 0) {
                throw new IllegalArgumentException("preparedStatementCacheSize has to be greater than 0 but it's set to " + this.preparedStatementsCacheSize);
            }
            if (this.securityDomain != null && this.username != null) {
                throw new IllegalArgumentException("Setting username is invalid in combination with securityDomain");
            }
            if (this.recoverySecurityDomain != null && this.recoveryUsername != null) {
                throw new IllegalArgumentException("Setting recoveryUsername is invalid in combination with recoverySecurityDomain");
            }
        }
    }
}

