/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.messaging;

import java.io.IOException;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.messaging.MessagingUtils;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;

public final class SetMessagingClusterPassword
implements OfflineCommand,
OnlineCommand {
    private final String serverName;
    private final String password;

    public SetMessagingClusterPassword(String password) {
        this(password, "default");
    }

    public SetMessagingClusterPassword(String password, String serverName) {
        if (password == null) {
            throw new IllegalArgumentException("Password must be specified as non null value");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Messaging server name must be specified as non null value");
        }
        this.serverName = serverName;
        this.password = password;
    }

    public void apply(OfflineCommandContext ctx) throws CommandFailedException, IOException {
        GroovyXmlTransform enableSecurity = GroovyXmlTransform.of(SetMessagingClusterPassword.class).subtree("messagingHornetq", Subtree.subsystem("messaging")).subtree("messagingActivemq", Subtree.subsystem("messaging-activemq")).parameter("password", this.password).build();
        ctx.client.apply(new OfflineCommand[]{enableSecurity});
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Operations ops = new Operations(ctx.client);
        Address address = MessagingUtils.address(ctx.client, this.serverName);
        ops.writeAttribute(address, "cluster-password", this.password);
    }
}

