/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.util;

import aQute.lib.utf8properties.UTF8Properties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.transformer.util.ByteData;

public class FileUtils {
    public static final int PAGE_SIZE = 4096;
    public static final int BUFFER_ADJUSTMENT = 65536;
    public static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    public static final char SLASH = '/';

    public static int verifyArray(int offset, long count) {
        if (offset < 0) {
            throw new IllegalArgumentException("Array offset [ " + offset + " ] less than zero.");
        }
        if (offset > 0x7FFFFFF7) {
            throw new IllegalArgumentException("Array offset [ " + offset + " ] greater than [ " + 0x7FFFFFF7 + " ]");
        }
        if (count < 0L) {
            throw new IllegalArgumentException("Array fill amount [ " + count + " ] less than zero [ 0 ]");
        }
        if (count > 0x7FFFFFF7L) {
            throw new IllegalArgumentException("Array fill amount [ " + count + " ] greater than [ " + 0x7FFFFFF7 + " ]");
        }
        int intCount = (int)count;
        int maxCount = 0x7FFFFFF7 - offset;
        if (intCount > maxCount) {
            throw new IllegalArgumentException("Array length [ " + maxCount + " ] from offset [ " + offset + " ] and fill amount [ " + intCount + " ] greater than [ " + 0x7FFFFFF7 + " ]");
        }
        return intCount;
    }

    public static ByteData read(String inputName, InputStream inputStream, int count) throws IOException {
        return FileUtils.read(inputName, inputStream, null, count);
    }

    public static ByteData read(String inputName, InputStream inputStream, byte[] buffer, int count) throws IOException {
        int actual;
        if (count == -1) {
            return FileUtils.read(inputName, inputStream, new byte[65536]);
        }
        count = FileUtils.verifyArray(0, count);
        if (buffer == null || count > buffer.length) {
            buffer = new byte[count];
        }
        int offset = 0;
        for (int remaining = count; remaining > 0; remaining -= actual) {
            actual = inputStream.read(buffer, offset, remaining);
            if (actual == -1) {
                throw new IOException("Premature end-of-stream [ " + inputName + " at [ " + offset + " ] requested [ " + remaining + " ]");
            }
            offset += actual;
        }
        return new ByteData(inputName, buffer, 0, count);
    }

    public static ByteData read(String inputName, InputStream inputStream) throws IOException {
        return FileUtils.read(inputName, inputStream, new byte[65536]);
    }

    public static ByteData read(String inputName, InputStream inputStream, byte[] buffer) throws IOException {
        int bytesRead;
        int bytesUsed = 0;
        int bytesRemaining = buffer.length;
        while ((bytesRead = inputStream.read(buffer, bytesUsed, bytesRemaining)) != -1) {
            bytesUsed += bytesRead;
            if ((bytesRemaining -= bytesRead) != 0) continue;
            int bytesAdded = 0x7FFFFFF7 - bytesUsed;
            if (bytesAdded == 0) {
                if (inputStream.read() == -1) break;
                throw new IOException("Overflow of [ " + inputName + " ] after reading [ " + bytesUsed + " ] bytes");
            }
            if (bytesAdded > 65536) {
                bytesAdded = 65536;
            }
            int nextLength = bytesUsed + 65536;
            bytesRemaining = 65536;
            byte[] nextBuffer = new byte[nextLength];
            System.arraycopy(buffer, 0, nextBuffer, 0, bytesUsed);
            buffer = nextBuffer;
        }
        return new ByteData(inputName, buffer, 0, bytesUsed);
    }

    public static long transfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[65536];
        return FileUtils.transfer(inputStream, outputStream, buffer);
    }

    public static long transfer(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        long totalBytesRead = 0L;
        int bytesRead = 0;
        while ((bytesRead = inputStream.read(buffer, 0, buffer.length)) != -1) {
            totalBytesRead += (long)bytesRead;
            outputStream.write(buffer, 0, bytesRead);
        }
        return totalBytesRead;
    }

    public static String normalize(String path) {
        if (File.separatorChar == '\\') {
            return path.replace(File.separatorChar, '/');
        }
        return path;
    }

    public static UTF8Properties loadProperties(URL url) throws IOException {
        try (InputStream stream = url.openStream();){
            UTF8Properties properties = FileUtils.createProperties();
            properties.load(stream);
            UTF8Properties uTF8Properties = properties;
            return uTF8Properties;
        }
    }

    public static UTF8Properties createProperties() {
        return new UTF8Properties();
    }

    public static String getFileNameFromFullyQualifiedFileName(String fqFileName) {
        int index = fqFileName.lastIndexOf(47);
        if (index != -1) {
            return fqFileName.substring(index + 1);
        }
        return fqFileName;
    }
}

