/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jboss.galleon.MessageWriter;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;

class JandexIndexer {
    JandexIndexer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createIndex(File jarFile, OutputStream target, MessageWriter log) throws IOException {
        Indexer indexer = new Indexer();
        JarFile jar = new JarFile(jarFile);
        ZipOutputStream zo = new ZipOutputStream(target);
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                try {
                    InputStream stream = jar.getInputStream(entry);
                    try {
                        indexer.index(stream);
                    }
                    finally {
                        JandexIndexer.safeClose(stream, log);
                    }
                }
                catch (Exception e) {
                    String message = e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage();
                    log.error("Could not index " + entry.getName() + ": " + message, new Object[]{e});
                }
            }
            zo.putNextEntry(new ZipEntry("META-INF/jandex.idx"));
            IndexWriter writer = new IndexWriter(zo);
            Index index = indexer.complete();
            writer.write(index);
        }
        finally {
            JandexIndexer.safeClose(zo, log);
            JandexIndexer.safeClose(jar, log);
            JandexIndexer.safeClose(target, log);
        }
    }

    private static void safeClose(Closeable closeable, MessageWriter log) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                log.error("Failed to close", new Object[]{e});
            }
        }
    }
}

