/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.cli;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.apache.maven.plugin.logging.Log;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;

public class ForkedCLIUtil {
    private static String javaHome;
    private static String javaCmd;

    private static String getJavaHome() {
        return javaHome == null ? (javaHome = System.getProperty("java.home")) : javaHome;
    }

    private static String getJavaCmd() {
        return javaCmd == null ? (javaCmd = Paths.get(ForkedCLIUtil.getJavaHome(), new String[0]).resolve("bin").resolve("java").toString()) : javaCmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fork(Log log, String[] artifacts, Class<?> clazz, Path home, Path output, String ... args) throws Exception {
        StringBuilder cp = new StringBuilder();
        for (String string : artifacts) {
            cp.append(string).append(File.pathSeparator);
        }
        StringBuilder contextCP = new StringBuilder();
        ForkedCLIUtil.collectCpUrls(ForkedCLIUtil.getJavaHome(), Thread.currentThread().getContextClassLoader(), contextCP);
        if (contextCP.length() == 0) {
            log.warn((CharSequence)"Re-using process classpath to retrieve Maven plugin classes to fork CLI process.");
            cp.append(System.getProperty("java.class.path"));
        } else {
            cp.append((CharSequence)contextCP);
        }
        Path properties = ForkedCLIUtil.storeSystemProps();
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(ForkedCLIUtil.getJavaCmd());
        argsList.add("-server");
        argsList.add("-cp");
        argsList.add(cp.toString());
        argsList.add(clazz.getName());
        argsList.add(home.toString());
        argsList.add(output.toString());
        argsList.add(properties.toString());
        for (String s : args) {
            argsList.add(s);
        }
        log.debug((CharSequence)("CLI process command line " + argsList));
        try {
            int exitCode;
            Process process;
            try {
                process = new ProcessBuilder(argsList).redirectErrorStream(true).start();
            }
            catch (IOException e) {
                throw new ProvisioningException("Failed to start forked process", (Throwable)e);
            }
            StringBuilder traces = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String line = reader.readLine();
                while (line != null) {
                    traces.append(line).append(System.lineSeparator());
                    line = reader.readLine();
                }
                if (process.isAlive()) {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((exitCode = process.exitValue()) != 0) {
                log.error((CharSequence)("Error executing CLI:" + traces));
                throw new Exception("CLI execution failed:" + traces);
            }
        }
        finally {
            Files.deleteIfExists(properties);
        }
    }

    private static Path storeSystemProps() throws ProvisioningException {
        Path props;
        try {
            props = Files.createTempFile("wfbootablejar", "sysprops", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to create a tmp file", (Throwable)e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(props, new OpenOption[0]);){
            System.getProperties().store(writer, "");
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.writeFile((Path)props), (Throwable)e);
        }
        return props;
    }

    private static void collectCpUrls(String javaHome, ClassLoader cl, StringBuilder buf) throws URISyntaxException {
        ClassLoader parentCl = cl.getParent();
        if (parentCl != null) {
            ForkedCLIUtil.collectCpUrls(javaHome, cl.getParent(), buf);
        }
        if (cl instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)cl).getURLs()) {
                String file = new File(url.toURI()).getAbsolutePath();
                if (file.startsWith(javaHome)) continue;
                if (buf.length() > 0) {
                    buf.append(File.pathSeparatorChar);
                }
                buf.append(file);
            }
        }
    }
}

