/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.wildfly.core.launcher.ProcessHelper;

class ServerHelper {
    public static final ModelNode EMPTY_ADDRESS = new ModelNode().setEmptyList();
    private static final Logger LOGGER = Logger.getLogger(ServerHelper.class);

    ServerHelper() {
    }

    public static boolean waitForDomain(Process process, DomainClient client, Map<ServerIdentity, ServerStatus> servers, long startupTimeout) throws InterruptedException, IOException {
        long sleep = 100L;
        for (long timeout = startupTimeout * 1000L; timeout > 0L; timeout -= 100L) {
            long before = System.currentTimeMillis();
            if (ServerHelper.isDomainRunning(client, servers)) {
                return true;
            }
            timeout -= System.currentTimeMillis() - before;
            if (ProcessHelper.processHasDied((Process)process)) {
                return false;
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        return false;
    }

    public static boolean isDomainRunning(DomainClient client, Map<ServerIdentity, ServerStatus> servers) {
        return ServerHelper.isDomainRunning(client, servers, false);
    }

    public static void shutdownDomain(DomainClient client, Map<ServerIdentity, ServerStatus> servers) {
        ModelNode address = new ModelNode().setEmptyList().add("host", "master");
        try {
            ModelNode op = Operations.createOperation((String)"stop-servers");
            ModelNode response = client.execute(op);
            if (Operations.isSuccessfulOutcome((ModelNode)response)) {
                op = Operations.createOperation((String)"shutdown", (ModelNode)address);
                response = client.execute(op);
                if (Operations.isSuccessfulOutcome((ModelNode)response)) {
                    while (ServerHelper.isDomainRunning(client, servers, true)) {
                        try {
                            TimeUnit.MILLISECONDS.sleep(20L);
                        }
                        catch (InterruptedException e) {
                            LOGGER.debug((Object)"Interrupted during sleep", (Throwable)e);
                        }
                    }
                } else {
                    LOGGER.debugf("Failed to execute %s: %s", (Object)op, (Object)Operations.getFailureDescription((ModelNode)response));
                }
            } else {
                LOGGER.debugf("Failed to execute %s: %s", (Object)op, (Object)Operations.getFailureDescription((ModelNode)response));
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Error shutting down domain", (Throwable)e);
        }
    }

    public static boolean waitForStandalone(Process process, ModelControllerClient client, long startupTimeout) throws InterruptedException, IOException {
        long sleep = 100L;
        for (long timeout = startupTimeout * 1000L; timeout > 0L; timeout -= 100L) {
            long before = System.currentTimeMillis();
            if (ServerHelper.isStandaloneRunning(client)) {
                return true;
            }
            timeout -= System.currentTimeMillis() - before;
            if (ProcessHelper.processHasDied((Process)process)) {
                return false;
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        return false;
    }

    public static boolean isStandaloneRunning(ModelControllerClient client) {
        try {
            ModelNode response = client.execute(Operations.createReadAttributeOperation((ModelNode)EMPTY_ADDRESS, (String)"server-state"));
            if (Operations.isSuccessfulOutcome((ModelNode)response)) {
                String state = Operations.readResult((ModelNode)response).asString();
                return !"starting".equals(state) && !"stopping".equals(state);
            }
        }
        catch (IOException | RuntimeException e) {
            LOGGER.debug((Object)"Interrupted determining if standalone is running", (Throwable)e);
        }
        return false;
    }

    public static void shutdownStandalone(ModelControllerClient client) {
        try {
            ModelNode op = Operations.createOperation((String)"shutdown");
            ModelNode response = client.execute(op);
            if (Operations.isSuccessfulOutcome((ModelNode)response)) {
                while (ServerHelper.isStandaloneRunning(client)) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.debug((Object)"Interrupted during sleep", (Throwable)e);
                    }
                }
            } else {
                LOGGER.debugf("Failed to execute %s: %s", (Object)op, (Object)Operations.getFailureDescription((ModelNode)response));
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Interrupted shutting down standalone", (Throwable)e);
        }
    }

    private static boolean isDomainRunning(DomainClient client, Map<ServerIdentity, ServerStatus> servers, boolean shutdown) {
        try {
            Map statuses = client.getServerStatuses();
            for (ServerIdentity id : statuses.keySet()) {
                ServerStatus status = (ServerStatus)statuses.get(id);
                switch (status) {
                    case DISABLED: 
                    case STARTED: {
                        servers.put(id, status);
                    }
                }
            }
            if (shutdown) {
                return statuses.isEmpty();
            }
            return statuses.size() == servers.size();
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Interrupted determining if domain is running", (Throwable)e);
            return false;
        }
    }

    static {
        EMPTY_ADDRESS.protect();
    }
}

