/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.security.auth.callback.CallbackHandler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecrypter;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.wildfly.plugin.common.ClientCallbackHandler;
import org.wildfly.plugin.common.ConnectionInfo;
import org.wildfly.plugin.server.ServerHelper;

public abstract class AbstractServerConnection
extends AbstractMojo
implements ConnectionInfo {
    public static final String DEBUG_MESSAGE_NO_CREDS = "No username and password in settings.xml file - falling back to CLI entry";
    public static final String DEBUG_MESSAGE_NO_ID = "No <id> element was found in the POM - Getting credentials from CLI entry";
    public static final String DEBUG_MESSAGE_NO_SERVER_SECTION = "No <server> section was found for the specified id";
    public static final String DEBUG_MESSAGE_NO_SETTINGS_FILE = "No settings.xml file was found in this Mojo's execution context";
    public static final String DEBUG_MESSAGE_POM_HAS_CREDS = "Getting credentials from the POM";
    public static final String DEBUG_MESSAGE_SETTINGS_HAS_CREDS = "Found username and password in the settings.xml file";
    public static final String DEBUG_MESSAGE_SETTINGS_HAS_ID = "Found the server's id in the settings.xml file";
    private volatile InetAddress address = null;
    private volatile CallbackHandler handler;
    @Parameter(property="wildfly.protocol")
    private String protocol;
    @Parameter(defaultValue="localhost", property="wildfly.hostname")
    private String hostname;
    @Parameter(defaultValue="9990", property="wildfly.port")
    private int port;
    @Parameter(property="wildfly.id")
    private String id;
    @Parameter(property="settings", readonly=true, required=true, defaultValue="${settings}")
    private Settings settings;
    @Parameter(property="wildfly.username")
    private String username;
    @Parameter(property="wildfly.password")
    private String password;
    @Component(role=SettingsDecrypter.class)
    private DefaultSettingsDecrypter settingsDecrypter;

    public final String hostname() {
        return this.hostname;
    }

    @Override
    public final int getPort() {
        return this.port;
    }

    public abstract String goal();

    @Override
    public final String getProtocol() {
        return this.protocol;
    }

    @Override
    public final synchronized InetAddress getHostAddress() {
        InetAddress result = this.address;
        if (result == null) {
            try {
                result = this.address = InetAddress.getByName(this.hostname());
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(String.format("Host name '%s' is invalid.", this.hostname), e);
            }
        }
        return result;
    }

    @Override
    public final synchronized CallbackHandler getCallbackHandler() {
        CallbackHandler result = this.handler;
        if (result == null) {
            if (this.username == null && this.password == null) {
                if (this.id != null) {
                    this.getCredentialsFromSettings();
                } else {
                    this.getLog().debug((CharSequence)DEBUG_MESSAGE_NO_ID);
                }
            } else {
                this.getLog().debug((CharSequence)DEBUG_MESSAGE_POM_HAS_CREDS);
            }
            result = this.handler = new ClientCallbackHandler(this.username, this.password);
        }
        return result;
    }

    protected final ModelControllerClient createClient() {
        return this.createClient(true);
    }

    protected final ModelControllerClient createClient(boolean autoWrapDomain) {
        ModelControllerClient client = ModelControllerClient.Factory.create((String)this.getProtocol(), (InetAddress)this.getHostAddress(), (int)this.getPort(), (CallbackHandler)this.getCallbackHandler());
        if (autoWrapDomain && ServerHelper.isDomainServer(client)) {
            return DomainClient.Factory.create((ModelControllerClient)client);
        }
        return client;
    }

    private void getCredentialsFromSettings() {
        if (this.settings != null) {
            Server server = this.settings.getServer(this.id);
            if (server != null) {
                this.getLog().debug((CharSequence)DEBUG_MESSAGE_SETTINGS_HAS_ID);
                this.password = this.decrypt(server);
                this.username = server.getUsername();
                if (this.username != null && this.password != null) {
                    this.getLog().debug((CharSequence)DEBUG_MESSAGE_SETTINGS_HAS_CREDS);
                } else {
                    this.getLog().debug((CharSequence)DEBUG_MESSAGE_NO_CREDS);
                }
            } else {
                this.getLog().debug((CharSequence)DEBUG_MESSAGE_NO_SERVER_SECTION);
            }
        } else {
            this.getLog().debug((CharSequence)DEBUG_MESSAGE_NO_SETTINGS_FILE);
        }
    }

    private String decrypt(Server server) {
        SettingsDecryptionResult decrypt = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(server));
        return decrypt.getServer().getPassword();
    }
}

