/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.jboss.jdf.stacks.client.StacksClient;
import org.jboss.jdf.stacks.model.Runtime;
import org.jboss.jdf.stacks.model.Stacks;

class RuntimeVersions {
    private final List<Runtime> availableRuntimes;

    private RuntimeVersions() {
        StacksClient client = new StacksClient();
        Stacks stacks = client.getStacks();
        this.availableRuntimes = Collections.synchronizedList(stacks.getAvailableRuntimes());
    }

    public static String getLatest(String groupId, String artifactId) {
        if (groupId == null) {
            throw new IllegalArgumentException("groupId cannot be null");
        }
        if (artifactId == null) {
            throw new IllegalArgumentException("artifactId cannot be null");
        }
        NavigableSet<String> versions = Holder.INSTANCE.getVersions(groupId, artifactId);
        return versions.isEmpty() ? "8.0.0.Final" : (String)versions.last();
    }

    public static String getLatestFinal(String groupId, String artifactId) {
        if (groupId == null) {
            throw new IllegalArgumentException("groupId cannot be null");
        }
        if (artifactId == null) {
            throw new IllegalArgumentException("artifactId cannot be null");
        }
        NavigableSet<String> versions = Holder.INSTANCE.getVersions(groupId, artifactId);
        for (String version : versions.descendingSet()) {
            String l = version.toLowerCase(Locale.ENGLISH);
            if (!l.endsWith("final") && !l.endsWith("ga")) continue;
            return version;
        }
        return "8.0.0.Final";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NavigableSet<String> getVersions(String groupId, String artifactId) {
        TreeSet<String> versions = new TreeSet<String>(new VersionComparator());
        List<Runtime> list = this.availableRuntimes;
        synchronized (list) {
            for (Runtime runtime : this.availableRuntimes) {
                if (!groupId.equalsIgnoreCase(runtime.getGroupId()) || !artifactId.equalsIgnoreCase(runtime.getArtifactId())) continue;
                versions.add(runtime.getVersion());
            }
        }
        return versions;
    }

    public static class VersionComparator
    implements Comparator<String> {
        private static final Pattern PATTERN = Pattern.compile(".", 16);

        @Override
        public int compare(String o1, String o2) {
            String[] vs1 = PATTERN.split(o1);
            String[] vs2 = PATTERN.split(o2);
            int result = 0;
            for (int i = 0; i < Math.min(vs1.length, vs2.length); ++i) {
                String s1 = vs1[i];
                String s2 = vs2[i];
                try {
                    Integer i1 = Integer.parseInt(s1);
                    Integer i2 = Integer.parseInt(s2);
                    result = i1.compareTo(i2);
                }
                catch (Exception e) {
                    result = s1.compareTo(s2);
                }
                if (result != 0) break;
            }
            return result;
        }
    }

    private static class Holder {
        static final RuntimeVersions INSTANCE = new RuntimeVersions();

        private Holder() {
        }
    }
}

