/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;
import org.wildfly.core.launcher.CliCommandBuilder;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.ProcessHelper;
import org.wildfly.plugin.cli.Commands;
import org.wildfly.plugin.common.ManagementClient;
import org.wildfly.plugin.common.ManagementClientConfiguration;
import org.wildfly.plugin.common.ServerOperations;

@Named
@Singleton
public class CommandExecutor {
    public void execute(ManagementClient client, Path wildflyHome, Commands commands) throws IOException {
        if (wildflyHome != null) {
            this.executeLocal(wildflyHome, client.getConfiguration(), commands);
        } else {
            this.executeCommands(client, commands);
        }
    }

    public void execute(ManagementClient client, String wildflyHome, Commands commands) throws IOException {
        Path path = null;
        if (wildflyHome != null) {
            path = Paths.get(wildflyHome, new String[0]);
        }
        this.execute(client, path, commands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommands(ModelControllerClient client, Commands commands) throws IOException {
        if (commands.hasCommands() || commands.hasScripts()) {
            NonClosingModelControllerClient c = new NonClosingModelControllerClient(client);
            CommandContext ctx = CommandExecutor.create(c);
            try {
                if (commands.isBatch()) {
                    CommandExecutor.executeBatch(ctx, commands.getCommands());
                } else {
                    CommandExecutor.executeCommands(ctx, commands.getCommands());
                }
                CommandExecutor.executeScripts(ctx, commands.getScripts());
            }
            finally {
                ctx.terminateSession();
                ctx.bindClient(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeLocal(Path wildflyHome, ManagementClientConfiguration configuration, Commands commands) throws IOException {
        if (commands.hasCommands()) {
            Path scriptFile = Files.createTempFile("localCliScript", ".cli", new FileAttribute[0]);
            try {
                try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(scriptFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE));){
                    if (commands.isBatch()) {
                        writer.println("batch");
                    }
                    for (String cmd : commands.getCommands()) {
                        writer.println(cmd);
                    }
                    if (commands.isBatch()) {
                        writer.println("run-batch");
                    }
                }
                this.executeLocal(wildflyHome, configuration, scriptFile);
            }
            finally {
                Files.deleteIfExists(scriptFile);
            }
        }
        if (commands.hasScripts()) {
            for (File scriptFile : commands.getScripts()) {
                this.executeLocal(wildflyHome, configuration, scriptFile.toPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeLocal(Path wildflyHome, ManagementClientConfiguration configuration, Path scriptFile) throws IOException {
        if (Files.notExists(scriptFile, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("File %s does not exist and cannot.", scriptFile));
        }
        CliCommandBuilder cliBuilder = CliCommandBuilder.of((Path)wildflyHome);
        cliBuilder.setConnection(configuration.getProtocol(), configuration.getHost(), configuration.getPort());
        cliBuilder.setUser(configuration.getUsername());
        cliBuilder.setPassword(configuration.getPassword());
        cliBuilder.addCliArguments(new String[]{"--file=" + scriptFile.toAbsolutePath()});
        Process process = Launcher.of((CommandBuilder)cliBuilder).addEnvironmentVariable("JBOSS_HOME", wildflyHome.toAbsolutePath().toString()).inherit().launch();
        try {
            int status = process.waitFor();
            if (status != 0) {
                throw new IllegalStateException("Process did not end normally: " + status);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            try {
                ProcessHelper.destroyProcess((Process)process);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static void executeScripts(CommandContext ctx, Iterable<File> scripts) throws IOException {
        for (File script : scripts) {
            try {
                BufferedReader reader = Files.newBufferedReader(script.toPath(), StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    String line = reader.readLine();
                    while (!ctx.isTerminated() && line != null) {
                        try {
                            ctx.handle(line.trim());
                        }
                        catch (CommandFormatException e) {
                            throw new IllegalArgumentException(String.format("Command '%s' is invalid. %s", line, e.getLocalizedMessage()), e);
                        }
                        catch (CommandLineException e) {
                            throw new IllegalArgumentException(String.format("Command execution failed for command '%s'. %s", line, e.getLocalizedMessage()), e);
                        }
                        line = reader.readLine();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to process file '" + script.getAbsolutePath() + "'", e);
            }
        }
    }

    private static void executeCommands(CommandContext ctx, Iterable<String> commands) throws IOException {
        for (String cmd : commands) {
            try {
                ctx.handle(cmd);
            }
            catch (CommandFormatException e) {
                throw new IllegalArgumentException(String.format("Command '%s' is invalid. %s", cmd, e.getLocalizedMessage()), e);
            }
            catch (CommandLineException e) {
                throw new IllegalArgumentException(String.format("Command execution failed for command '%s'. %s", cmd, e.getLocalizedMessage()), e);
            }
        }
    }

    private static void executeBatch(CommandContext ctx, Iterable<String> commands) throws IOException {
        BatchManager batchManager = ctx.getBatchManager();
        if (batchManager.activateNewBatch()) {
            Batch batch = batchManager.getActiveBatch();
            for (String cmd : commands) {
                try {
                    batch.add(ctx.toBatchedCommand(cmd));
                }
                catch (CommandFormatException e) {
                    throw new IllegalArgumentException(String.format("Command '%s' is invalid. %s", cmd, e.getLocalizedMessage()), e);
                }
            }
            ModelNode result = ctx.getModelControllerClient().execute(batch.toRequest());
            if (!ServerOperations.isSuccessfulOutcome((ModelNode)result)) {
                throw new IllegalArgumentException(ServerOperations.getFailureDescriptionAsString(result));
            }
        }
    }

    private static CommandContext create(ModelControllerClient client) {
        CommandContext commandContext;
        try {
            commandContext = CommandContextFactory.getInstance().newCommandContext();
            commandContext.bindClient(client);
        }
        catch (CliInitializationException e) {
            throw new IllegalStateException("Failed to initialize CLI context", e);
        }
        return commandContext;
    }

    private static class NonClosingModelControllerClient
    implements ModelControllerClient {
        private final ModelControllerClient delegate;

        NonClosingModelControllerClient(ModelControllerClient delegate) {
            this.delegate = delegate;
        }

        public ModelNode execute(ModelNode operation) throws IOException {
            return this.delegate.execute(operation);
        }

        public ModelNode execute(Operation operation) throws IOException {
            return this.delegate.execute(operation);
        }

        public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
            return this.delegate.execute(operation, messageHandler);
        }

        public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
            return this.delegate.execute(operation, messageHandler);
        }

        public OperationResponse executeOperation(Operation operation, OperationMessageHandler messageHandler) throws IOException {
            return this.delegate.executeOperation(operation, messageHandler);
        }

        public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
            return this.delegate.executeAsync(operation, messageHandler);
        }

        public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
            return this.delegate.executeAsync(operation, messageHandler);
        }

        public AsyncFuture<OperationResponse> executeOperationAsync(Operation operation, OperationMessageHandler messageHandler) {
            return this.delegate.executeOperationAsync(operation, messageHandler);
        }

        public void close() throws IOException {
        }
    }
}

