/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.ProcessHelper;
import org.wildfly.plugin.common.ServerOperations;

public class ServerHelper {
    public static final ModelNode EMPTY_ADDRESS = new ModelNode().setEmptyList();
    private static final Logger LOGGER = Logger.getLogger(ServerHelper.class);

    public static boolean isDomainServer(ModelControllerClient client) throws IOException {
        boolean result = false;
        ModelNode op = ServerOperations.createReadAttributeOperation("launch-type");
        ModelNode opResult = client.execute(op);
        if (ServerOperations.isSuccessfulOutcome((ModelNode)opResult)) {
            result = "DOMAIN".equals(ServerOperations.readResultAsString(opResult));
        }
        return result;
    }

    static Process startProcess(CommandBuilder commandBuilder, Map<String, String> env, OutputStream stdout) throws IOException {
        Launcher launcher = Launcher.of((CommandBuilder)commandBuilder);
        if (env != null) {
            launcher.addEnvironmentVariables(env);
        }
        if (stdout == null) {
            launcher.inherit();
        } else {
            launcher.setRedirectErrorStream(true);
        }
        Process process = launcher.launch();
        if (stdout != null) {
            ServerHelper.consumeOutput(process, stdout);
        }
        return process;
    }

    static void waitForDomain(Process process, DomainClient client, long startupTimeout) throws InterruptedException, IOException {
        long timeout;
        long sleep = 100L;
        for (timeout = startupTimeout * 1000L; timeout > 0L; timeout -= 100L) {
            long before = System.currentTimeMillis();
            if (ServerHelper.isDomainRunning(client)) break;
            timeout -= System.currentTimeMillis() - before;
            if (ProcessHelper.processHasDied((Process)process)) {
                throw new RuntimeException(String.format("The process has unexpectedly exited with code %d", process.exitValue()));
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        if (timeout <= 0L) {
            process.destroy();
            throw new RuntimeException(String.format("The server did not start within %s seconds.", startupTimeout));
        }
    }

    static boolean isDomainRunning(DomainClient client) {
        return ServerHelper.isDomainRunning(client, new HashMap<ServerIdentity, ServerStatus>(), false);
    }

    static void shutdownDomain(DomainClient client) {
        ServerHelper.shutdownDomain(client, new HashMap<ServerIdentity, ServerStatus>());
    }

    static ModelNode determineHostAddress(ModelControllerClient client) throws IOException {
        ModelNode response = client.execute(Operations.createReadAttributeOperation((ModelNode)EMPTY_ADDRESS, (String)"local-host-name"));
        if (Operations.isSuccessfulOutcome((ModelNode)response)) {
            return ServerOperations.createAddress("host", Operations.readResult((ModelNode)response).asString());
        }
        throw new RuntimeException("Could not determine host name; " + Operations.getFailureDescription((ModelNode)response).asString());
    }

    static void shutdownDomain(DomainClient client, Map<ServerIdentity, ServerStatus> servers) {
        ModelNode address = new ModelNode().setEmptyList().add("host", "master");
        try {
            ModelNode op = Operations.createOperation((String)"stop-servers");
            ModelNode response = client.execute(op);
            if (Operations.isSuccessfulOutcome((ModelNode)response)) {
                op = Operations.createOperation((String)"shutdown", (ModelNode)address);
                response = client.execute(op);
                if (Operations.isSuccessfulOutcome((ModelNode)response)) {
                    while (ServerHelper.isDomainRunning(client, servers, true)) {
                        try {
                            TimeUnit.MILLISECONDS.sleep(20L);
                        }
                        catch (InterruptedException e) {
                            LOGGER.debug((Object)"Interrupted during sleep", (Throwable)e);
                        }
                    }
                } else {
                    LOGGER.debugf("Failed to execute %s: %s", (Object)op, (Object)Operations.getFailureDescription((ModelNode)response));
                }
            } else {
                LOGGER.debugf("Failed to execute %s: %s", (Object)op, (Object)Operations.getFailureDescription((ModelNode)response));
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Error shutting down domain", (Throwable)e);
        }
    }

    static void waitForStandalone(Process process, ModelControllerClient client, long startupTimeout) throws InterruptedException, IOException {
        long timeout;
        long sleep = 100L;
        for (timeout = startupTimeout * 1000L; timeout > 0L; timeout -= 100L) {
            long before = System.currentTimeMillis();
            if (ServerHelper.isStandaloneRunning(client)) break;
            timeout -= System.currentTimeMillis() - before;
            if (ProcessHelper.processHasDied((Process)process)) {
                throw new RuntimeException(String.format("The process has unexpectedly exited with code %d", process.exitValue()));
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        if (timeout <= 0L) {
            process.destroy();
            throw new RuntimeException(String.format("The server did not start within %s seconds.", startupTimeout));
        }
    }

    static boolean isStandaloneRunning(ModelControllerClient client) {
        try {
            ModelNode response = client.execute(Operations.createReadAttributeOperation((ModelNode)EMPTY_ADDRESS, (String)"server-state"));
            if (Operations.isSuccessfulOutcome((ModelNode)response)) {
                String state = Operations.readResult((ModelNode)response).asString();
                return !"starting".equals(state) && !"stopping".equals(state);
            }
        }
        catch (IOException | RuntimeException e) {
            LOGGER.debug((Object)"Interrupted determining if standalone is running", (Throwable)e);
        }
        return false;
    }

    static void shutdownStandalone(ModelControllerClient client) {
        try {
            ModelNode op = Operations.createOperation((String)"shutdown");
            ModelNode response = client.execute(op);
            if (Operations.isSuccessfulOutcome((ModelNode)response)) {
                while (ServerHelper.isStandaloneRunning(client)) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.debug((Object)"Interrupted during sleep", (Throwable)e);
                    }
                }
            } else {
                LOGGER.debugf("Failed to execute %s: %s", (Object)op, (Object)Operations.getFailureDescription((ModelNode)response));
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Interrupted shutting down standalone", (Throwable)e);
        }
    }

    private static Thread consumeOutput(Process process, OutputStream stdout) {
        Thread thread = new Thread((Runnable)new ConsoleConsumer(process.getInputStream(), stdout), "WildFly-stdout");
        thread.start();
        return thread;
    }

    private static boolean isDomainRunning(DomainClient client, Map<ServerIdentity, ServerStatus> servers, boolean shutdown) {
        try {
            ModelNode hostAddress = ServerHelper.determineHostAddress((ModelControllerClient)client);
            Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create().addStep(Operations.createReadAttributeOperation((ModelNode)hostAddress, (String)"running-mode")).addStep(Operations.createReadAttributeOperation((ModelNode)hostAddress, (String)"host-state"));
            ModelNode response = client.execute(builder.build());
            if (Operations.isSuccessfulOutcome((ModelNode)response) && "ADMIN_ONLY".equals(Operations.readResult((ModelNode)(response = Operations.readResult((ModelNode)response)).get("step-1")).asString()) && Operations.isSuccessfulOutcome((ModelNode)response.get("step-2"))) {
                String state = Operations.readResult((ModelNode)response).asString();
                return !"starting".equals(state) && !"stopping".equals(state);
            }
            Map statuses = client.getServerStatuses();
            for (ServerIdentity id : statuses.keySet()) {
                ServerStatus status = (ServerStatus)statuses.get(id);
                switch (status) {
                    case DISABLED: 
                    case STARTED: {
                        servers.put(id, status);
                    }
                }
            }
            if (shutdown) {
                return statuses.isEmpty();
            }
            return statuses.size() == servers.size();
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Interrupted determining if domain is running", (Throwable)e);
            return false;
        }
    }

    static {
        EMPTY_ADDRESS.protect();
    }

    private static class ConsoleConsumer
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;

        ConsoleConsumer(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[64];
            try {
                int len;
                while ((len = this.in.read(buffer)) != -1) {
                    this.out.write(buffer, 0, len);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

