/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.StandaloneCommandBuilder;
import org.wildfly.plugin.cli.CommandConfiguration;
import org.wildfly.plugin.cli.CommandExecutor;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.common.Utils;
import org.wildfly.plugin.core.Deployment;
import org.wildfly.plugin.core.DeploymentManager;
import org.wildfly.plugin.core.GalleonUtils;
import org.wildfly.plugin.core.MavenRepositoriesEnricher;
import org.wildfly.plugin.core.ServerHelper;
import org.wildfly.plugin.deployment.PackageType;
import org.wildfly.plugin.server.AddUser;
import org.wildfly.plugin.server.ModulesPath;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.PACKAGE)
public class RunMojo
extends AbstractServerConnection {
    @Component
    RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    MavenSession mavenSession;
    @Inject
    private CommandExecutor commandExecutor;
    @Parameter(alias="jboss-home", property="jboss-as.home")
    private String jbossHome;
    @Parameter(property="wildfly.version")
    private String version;
    @Parameter(alias="provisioning-dir", property="wildfly.provisioning.dir", defaultValue="server")
    private String provisioningDir;
    @Parameter(alias="modules-path", property="wildfly.modulesPath")
    private ModulesPath modulesPath;
    @Parameter(alias="java-opts", property="wildfly.javaOpts")
    private String[] javaOpts;
    @Parameter(alias="java-home", property="java.home")
    private String javaHome;
    @Parameter(property="wildfly.commands")
    private List<String> commands = new ArrayList<String>();
    @Parameter(property="wildfly.scripts")
    private List<File> scripts = new ArrayList<File>();
    @Parameter(alias="server-config", property="wildfly.serverConfig")
    private String serverConfig;
    @Parameter(alias="properties-file", property="wildfly.propertiesFile")
    private String propertiesFile;
    @Parameter(alias="startup-timeout", defaultValue="60", property="wildfly.startupTimeout")
    private long startupTimeout;
    @Parameter(alias="server-args", property="wildfly.serverArgs")
    private String[] serverArgs;
    @Parameter(alias="add-user", property="wildfly.add-user")
    private AddUser addUser;
    @Parameter
    private Map<String, String> env;
    @Parameter(property="wildfly.deployment.name")
    private String name;
    @Parameter(alias="runtime-name", property="wildfly.deployment.runtime.name")
    private String runtimeName;
    @Parameter(defaultValue="${project.build.directory}/", property="wildfly.deployment.targetDir")
    private File targetDir;
    @Parameter(property="wildfly.deployment.filename")
    private String filename;
    @Parameter(defaultValue="false", property="wildfly.skip")
    private boolean skip;
    private MavenRepoManager mavenRepoManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        MavenRepositoriesEnricher.enrich((MavenSession)this.mavenSession, (MavenProject)this.project, this.repositories);
        this.mavenRepoManager = new MavenArtifactRepositoryManager(this.repoSystem, this.session, this.repositories);
        Log log = this.getLog();
        Path deploymentContent = this.getDeploymentContent();
        if (Files.notExists(deploymentContent, new LinkOption[0])) {
            throw new MojoExecutionException(String.format("The deployment '%s' could not be found.", deploymentContent.toAbsolutePath()));
        }
        Path wildflyPath = this.provisionIfRequired(deploymentContent.getParent().resolve(this.provisioningDir));
        if (!ServerHelper.isValidHomeDirectory((Path)wildflyPath)) {
            throw new MojoExecutionException(String.format("JBOSS_HOME '%s' is not a valid directory.", wildflyPath));
        }
        StandaloneCommandBuilder commandBuilder = this.createCommandBuilder(wildflyPath);
        log.info((CharSequence)("JAVA_HOME : " + commandBuilder.getJavaHome()));
        log.info((CharSequence)("JBOSS_HOME: " + commandBuilder.getWildFlyHome()));
        log.info((CharSequence)("JAVA_OPTS : " + Utils.toString(commandBuilder.getJavaOptions(), " ")));
        try {
            if (this.addUser != null && this.addUser.hasUsers()) {
                log.info((CharSequence)("Adding users: " + this.addUser));
                this.addUser.addUsers(commandBuilder.getWildFlyHome(), commandBuilder.getJavaHome());
            }
            log.info((CharSequence)"Server is starting up. Press CTRL + C to stop the server.");
            Process process = this.startContainer((CommandBuilder)commandBuilder);
            try (ModelControllerClient client = this.createClient();){
                CommandConfiguration cmdConfig = CommandConfiguration.of(this::createClient, this::getClientConfiguration).addCommands(this.commands).addScripts(this.scripts).setJBossHome(commandBuilder.getWildFlyHome()).setFork(true).setStdout("none").setTimeout(this.timeout);
                this.commandExecutor.execute(cmdConfig, this.mavenRepoManager);
                Deployment deployment = Deployment.of((Path)deploymentContent).setName(this.name).setRuntimeName(this.runtimeName);
                DeploymentManager deploymentManager = DeploymentManager.Factory.create((ModelControllerClient)client);
                deploymentManager.forceDeploy(deployment);
            }
            catch (MojoExecutionException | MojoFailureException e) {
                if (process != null) {
                    process.destroyForcibly().waitFor(10L, TimeUnit.SECONDS);
                }
                throw e;
            }
            try {
                boolean keepRunning = true;
                while (keepRunning) {
                    int exitCode = process.waitFor();
                    if (exitCode == 10) {
                        process.destroy();
                        process = this.startContainer((CommandBuilder)commandBuilder);
                        continue;
                    }
                    keepRunning = false;
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("The server failed to start", e);
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("The server failed to start", e);
        }
    }

    public void setJavaOpts(String value) {
        if (value != null) {
            this.javaOpts = value.split("\\s+");
        }
    }

    private StandaloneCommandBuilder createCommandBuilder(Path wildflyPath) {
        StandaloneCommandBuilder commandBuilder = (StandaloneCommandBuilder)StandaloneCommandBuilder.of((Path)wildflyPath).setJavaHome(this.javaHome).addModuleDirs(this.modulesPath.getModulePaths());
        if (Utils.isNotNullOrEmpty(this.javaOpts)) {
            commandBuilder.setJavaOptions(this.javaOpts);
        }
        if (this.serverConfig != null) {
            commandBuilder.setServerConfiguration(this.serverConfig);
        }
        if (this.propertiesFile != null) {
            commandBuilder.setPropertiesFile(this.propertiesFile);
        }
        if (this.serverArgs != null) {
            commandBuilder.addServerArguments(this.serverArgs);
        }
        return commandBuilder;
    }

    private Path provisionIfRequired(Path installDir) throws MojoFailureException {
        if (this.jbossHome != null) {
            return Paths.get(this.jbossHome, new String[0]);
        }
        try {
            if (!Files.exists(installDir, new LinkOption[0])) {
                this.getLog().info((CharSequence)("Provisioning default WildFly server in " + installDir));
                GalleonUtils.provision((Path)installDir, (String)this.version, (MavenRepoManager)this.mavenRepoManager);
            }
            return installDir;
        }
        catch (ProvisioningException ex) {
            throw new MojoFailureException(ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    @Override
    public String goal() {
        return "run";
    }

    private Process startContainer(CommandBuilder commandBuilder) throws IOException, InterruptedException, TimeoutException {
        Launcher launcher = Launcher.of((CommandBuilder)commandBuilder).inherit();
        if (this.env != null) {
            launcher.addEnvironmentVariables(this.env);
        }
        Process process = launcher.launch();
        try (ModelControllerClient client = this.createClient();){
            ServerHelper.waitForStandalone((Process)process, (ModelControllerClient)client, (long)this.startupTimeout);
        }
        return process;
    }

    private Path getDeploymentContent() {
        PackageType packageType = PackageType.resolve(this.project);
        String filename = this.filename == null ? String.format("%s.%s", this.project.getBuild().getFinalName(), packageType.getFileExtension()) : this.filename;
        return this.targetDir.toPath().resolve(filename);
    }
}

