/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.common;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

public class Archives {
    public static Path uncompress(Path archiveFile, Path targetDir) throws IOException {
        return Archives.uncompress(archiveFile, targetDir, false);
    }

    public static Path uncompress(Path archiveFile, Path targetDir, boolean replaceIfExists) throws IOException {
        Path path;
        block11: {
            Path archive = Archives.getArchive(archiveFile);
            Path firstDir = null;
            ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(archive, new OpenOption[0])));
            try {
                ArchiveEntry entry;
                while ((entry = in.getNextEntry()) != null) {
                    Path extractTarget = targetDir.resolve(entry.getName());
                    if (!replaceIfExists && Files.exists(extractTarget, new LinkOption[0])) {
                        if (!entry.isDirectory() || firstDir != null) continue;
                        firstDir = extractTarget;
                        continue;
                    }
                    if (entry.isDirectory()) {
                        Path dir = Files.createDirectories(extractTarget, new FileAttribute[0]);
                        if (firstDir != null) continue;
                        firstDir = dir;
                        continue;
                    }
                    Files.createDirectories(extractTarget.getParent(), new FileAttribute[0]);
                    Files.copy((InputStream)in, extractTarget, new CopyOption[0]);
                }
                Path path2 = path = firstDir == null ? targetDir : firstDir;
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ArchiveException e) {
                    throw new IOException(e);
                }
            }
            in.close();
        }
        return path;
    }

    private static Path getArchive(Path path) throws IOException {
        Path result;
        block9: {
            String fileName = path.getFileName().toString();
            String loweredFileName = fileName.toLowerCase(Locale.ENGLISH);
            if (loweredFileName.endsWith(".gz")) {
                String tempFileName = fileName.substring(0, loweredFileName.indexOf(".gz"));
                int index = tempFileName.lastIndexOf(46);
                result = index > 0 ? Files.createTempFile(tempFileName.substring(0, index), tempFileName.substring(index), new FileAttribute[0]) : Files.createTempFile(tempFileName.substring(0, index), "", new FileAttribute[0]);
                try (CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));){
                    Files.copy((InputStream)in, result, StandardCopyOption.REPLACE_EXISTING);
                    break block9;
                }
                catch (CompressorException e) {
                    throw new IOException(e);
                }
            }
            result = path;
        }
        return result;
    }
}

